
## Stash v0.12 Changelog

### 0.12.3

*   Fixed invalidation default value.


### 0.12.2

*   Added an alternative format than native PHP for the Filesystem Driver.

*   Improved performance of Filesystem clear operations.

*   Better commenting on files generated by Filesystem driver.

*   Added work around for HHVM APCIterator bug.

*   Improved Redis error handling in the event of a lost or disconnected server.

*   Improved Redis and Memcached persistent connection support.

*   Added support for AWS autodiscovery functionality in Memcached.

*   Refactored PDO and SQLite "isAvailable" functions to prevent notices when the PDO extension is not present.

*   Docblock and commenting improvements.

*   Updated dependency versions (only affects development code).


#### API Changes

*   Added a new "encoder" option to the Filesystem driver. This option defaults to previous behavior to maintain backwards compatibility while also offering the ability to change the format of the file used to store cached items.



### 0.12.1

*   Full HHVM Support

*   Removed xcache experimental driver.

*   Removed PEAR Support

*   Internal Improvements- DocBlock, Explicitly Defined Variables, Commenting.

*   Enforcement of code standards in test suite.

*   FileSystem - Improved Storage and Retrieval

*   Memcache - Altered subdrivers constructors and initialization.

*   SQLite - Reduced duplicate code amongst PDO subdrivers.

*   Updated Test Suite to make it simple to run again custom Pool or Item objects other than the build in ones.

*   Redis and Memcache constructors now take both forms (associative array or indexed array) when setting server configuration. Originally Memcache accepted an indexed list of settings while Redis expected an associative array.


#### API Changes

*   Removed constructor requirements from DriverInterface and added setOptions to replace it. Please note this means *all* drivers no longer take their options through the constructor, but expect them through the setOptions method.

*   Replaced "Item->setDriver" with "Item->setPool" function. This should have no effect on typical consumers of this library but may effect those extending the Item or Pool class.

*   Renamed Drivers class to DriversList to prevent confusion when talking about "Drivers".

*   Added DriversList::getAllDrivers which returns an unfiltered list of registered drivers.

*   Added DriversList::getAvailableDrivers to replace the existing DriversList::getDrivers, which is now deprecated.

*   Added "setDriver(DriverInterface $driver)" and "setKey($key, $namespace = null)" functions to the Item Interface. These functions are used by Pool to initialize the Item class.

*   Added "setNamespace($namespace = null)" and "getNamespace()" functions to the Pool class for.

*   Added "getCreation()" and "getExpiration()" functions to the Item class.

*   Added internal function Utilities::checkFileSystemPermissions.

*   Moved Item::SP_* Constants to new Invalidation class and Deprecated the existing Item::SP_* constants.

*   "PRECOMPUTE" is now the default method for dealing with stale data.



## Stash v0.11 Changelog

### 0.11.6

*   FileSystem compatibility fix for the new OpCache system in later versions of PHP.


### 0.11.5

*   Fixed a bug where OSX would be identified as Windows and path names were limited to that system's length.

*   Fixed a bug in the Pool class where setItemClass would throw an exception.


### 0.11.4

*   Introduced HHVM testing capabilities into the test suite.

*   Removed HHVM specific fatal errors.



### 0.11.3

*   Fixed potential key collision with Ephemeral driver.


### 0.11.2

*   Fixed Bug which prevented some file based caches from purging or flushing on Windows based systems.

*   Fixed Bug in the Filesystem cache which caused a fatal error when certain keys were used.


### 0.11.1


*   Logging Support

    The Pool and Item classes can now have PSR-3 compliant Logging libraries injected into them through the setLogger($logger) functions. Any logger injected into the Pool class will get injected into any Items it generates.


*   Pool and Item Interfaces

    The Stash\Pool and Stash\Item classes now implement the new Stash\Interface\Pool and Stash\interface\Item inferaces.


*   Extend Cache renamed and given a ttl

    The Stash\Item::extendCache() function is now Stash\Item::extend($ttl = null).


*   Formatting changes, PSR-1 and PSR-2 compliant.


*   Added "setItemClass" function to the Pool class

    This allows new Item classes to be generated, as long as they following the new interface.
