<?php
require ('conf/db.php');
include ('includes/funciones.php');
// Definicion de variables
$anio = date('Y'); // Anio por defecto
$anio_trans_activa = 2024; // Año fin transparencia matrices
$mes_trans_activa = 3; // Mes fin transparencia matrices
if ($_GET) {
    $anio = $_GET['anio'];
}
try {
    $select_stmt = $db->prepare("SELECT m.idmatriz, dm.orden, ar.anio, ar.mes, CONCAT(dm.abrev,') ', dm.descripcion) AS descripcion, ar.nombrearchivo 
        FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat
            INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo
        WHERE m.estado=3 AND ar.anio=:anio
        ORDER BY ar.mes, dm.orden, dm.abrev");
    $select_stmt->bindParam(":anio", $anio);
    $select_stmt->execute();
} catch (PDOException $e) {
    $observaciones = $e->getMessage();
}
$matrices = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html>

<head>
    <meta charset='utf-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1'>
    <title>Transparencia</title>

    <!-- Bootstrap CSS v5.3.0 min
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">
    -->

    <!-- Iconos awsome fonts 
    <link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css' rel='stylesheet'>
    -->

    <!-- Bootstrap JavaScript Libraries 
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"
        integrity="sha384-oBqDVmMz9ATKxIep9tiCxS/Z9fNfEXiDAYTujMAeBAsjFuCZSmKbSSUnQlmh/jp3" crossorigin="anonymous">
        </script>
        -->

    <!-- Jquery v3.6.4 -->
    <script type='text/javascript' src='https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js'></script>

    <!-- Bootstrap CSS v5.3.0 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">

    <!-- Bootstrap CSS v5.3.0 -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe"
        crossorigin="anonymous"></script>

    <!-- Ionic icons -->
    <link href="https://unpkg.com/ionicons@4.5.10-0/dist/css/ionicons.min.css" rel="stylesheet">
    <link rel="StyleSheet" href="assets/css/sidebar.css" type="text/css">

    <!-- No permitir cache -->
    <meta http-equiv='cache-control' content='no-cache'>
    <meta http-equiv='expires' content='0'>
    <meta http-equiv='pragma' content='no-cache'>
</head>

<body>
    <main class='container'>
        <div class="wrapper">
            <nav id="sidebar">
                <div class="sidebar-header">
                    <h3 class="icon ion-md-folder"> LOTAIP</h3>
                    <hr>
                </div>
                <?php
                try {
                    $select_stmt = $db->prepare("SELECT DISTINCT ar.anio FROM matrices m INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo
                        WHERE m.estado=3 ORDER BY ar.anio DESC");
                    $select_stmt->execute();
                } catch (PDOException $e) {
                    echo $e->getMessage();
                }
                $anios = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
                try {
                    $select_stmt = $db->prepare("SELECT min(ar.mes) as mes FROM matrices m INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo
                        WHERE m.estado=3 AND ar.anio=:anio ORDER BY ar.anio DESC");
                    $select_stmt->bindParam(":anio", $anio);
                    $select_stmt->execute();
                } catch (PDOException $e) {
                    echo $e->getMessage();
                }
                $mes_min = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
                ?>
                <ul class="list-unstyled components">
                    <li>
                        <a class="dropdown-toggle icon ion-md-calendar" href="#homeSubmenu" data-toggle="collapse"
                            aria-expanded="false"> Seleccionar período</a>
                        <ul class="collapse list-unstyled" id="homeSubmenu">
                            <?php
                            foreach ($anios as $a) {
                                echo '<li><a class="ion-md-calendar" href="index.php?anio=' . $a['anio'] . '"> ' . $a['anio'] . '</a></li>';
                            }
                            ?>
                            <li> <a class="ion-md-apps" href="https://www.rpcayambe.gob.ec/site/lotaip-art-7/"
                                    target="_blank"> Años/Meses anteriores</a> </li>
                        </ul>
                    </li>
                </ul>
            </nav>
            <div class="w-100">
                <div class="content-wrapper">
                    <div class="alert alert-secondary">
                        <h2><b>«TRANSPARENCIA ACTIVA»</b></h2>
                        <h4>Período
                            <?php echo $anio; ?>
                        </h4>
                        <div>
                            <div class="line"></div>
                        </div>
                        <section class="bg-light py-3">
                            <form>
                                <div class="accordion" id="accordionMeses">
                                    <?php
                                    $matrices_mensual = array();
                                    for ($i = $mes_min[0]['mes']; $i <= 12; $i++) {
                                        $matrices_mensual = [];
                                        foreach ($matrices as $m) {
                                            // Publica matrices y/o plantillas LOTAIP 2024 a partir de abril de 2024
                                            if ($m['mes'] == $i && $m['anio'] < $anio_trans_activa) {
                                                array_push($matrices_mensual, $m);
                                            } elseif ($m['mes'] == $i && $m['anio'] == $anio_trans_activa && $m['mes'] <= $mes_trans_activa) {
                                                array_push($matrices_mensual, $m);
                                            } elseif ($m['mes'] == $i && $m['orden'] == 0) {
                                                array_push($matrices_mensual, $m);
                                            }
                                        }
                                        // Despliega mes si contiene matrices
                                        if (count($matrices_mensual) > 0) {
                                            ?>
                                            <div class="accordion-items">
                                                <h2 class="accordion-header">
                                                    <!-- Nombre mes -->
                                                    <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                                        aria-expanded="" aria-controls="">
                                                        <?php echo '<span class="ion-ios-folder-open" style="font-size=12px"><strong> ' . GetNombreMes($i) . '</strong> (' . count($matrices_mensual) . ' items)</span>'; ?>
                                                    </button>
                                                </h2>
                                                <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse"
                                                    data-bs-parent="#accordionMeses">
                                                    <div class="accordion-body">
                                                        <div class="list-group">
                                                            <?php
                                                            foreach ($matrices_mensual as $m) {
                                                                // Obtengo la extensión del archivo a mostrar
                                                                $info = new SplFileInfo($m["nombrearchivo"]);
                                                                $ext = $info->getExtension();
                                                                ?>
                                                                <!-- Nombre de la matriz -->
                                                                <button class="accordion-button" type="button"
                                                                    data-bs-toggle="collapse"
                                                                    data-bs-target="#sub-<?php echo $i . $m['idmatriz']; ?>"
                                                                    aria-expanded="false"
                                                                    aria-controls="sub-<?php echo $i . $m['idmatriz']; ?>">
                                                                    <?php echo '<span style="font-size=12px">' . $m['descripcion'] . '</span>'; ?>
                                                                </button>
                                                                <!-- Botones de matriz-->
                                                                <div id="sub-<?php echo $i . $m['idmatriz']; ?>"
                                                                    class="accordion-collapse collapse hide"
                                                                    aria-labelledby="sub-headingOne"
                                                                    data-bs-parent="#sub-accordion">
                                                                    <?php if (strtolower($ext) == 'pdf') { // orden=0:: Matrices Transparencia (4) ?>
                                                                        <div class="accordion-body">
                                                                            <a type="button"
                                                                                href="./repositorio/<?php echo $m["nombrearchivo"]; ?>"
                                                                                class="btn btn-success" target="_blank">Download</a>
                                                                        </div>
                                                                    <?php } else { ?>
                                                                        <div class="accordion-body">
                                                                            <button type="button" class="btn btn-success"
                                                                                onclick='descargar_archivo("<?php echo $m["nombrearchivo"]; ?>", "Conjunto");'
                                                                                title="Conjunto de datos">Conjunto de datos</i>
                                                                            </button>
                                                                            <button type="button" class="btn btn-success"
                                                                                onclick='descargar_archivo("<?php echo $m["nombrearchivo"]; ?>", "Metadatos");'
                                                                                title="Conjunto de datos">Metadatos</i>
                                                                            </button>
                                                                            <button type="button" class="btn btn-success"
                                                                                onclick='descargar_archivo("<?php echo $m["nombrearchivo"]; ?>", "Diccionario");'
                                                                                title="Conjunto de datos">Diccionario</i>
                                                                            </button>
                                                                        </div>

                                                                    <?php } ?>
                                                                </div>
                                                                <?php
                                                            }
                                                            ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                    }
                                    ?>
                                </div>
                            </form>
                        </section>
                    </div>
                </div>
                <!---Formulario invisible para generar descarga de archivos CSV--->
                <form id='download-form' action="descargar.php" method='post' target="_self" style="display:none">
                    <input type="hidden" name="matriz_zip" id="matriz_zip">
                    <input type="hidden" name="tipo_csv" id="tipo_csv">
                </form>
                <!---Función para Descargar archivos CSV--->
                <script language="javascript">
                    const descargar_archivo = async function (matriz_zip, tipo_csv) {
                        $('#matriz_zip', '#download-form').val(matriz_zip);
                        $('#tipo_csv', '#download-form').val(tipo_csv);
                        $('#download-form').submit();
                    };
                </script>
                <!---CDN Bootstrap--->
                <script type='text/javascript'
                    src='https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js'>
                    </script>
                <!---Muestra menu lateral cerrado--->
                <script type='text/javascript'>$(document).ready(function () {
                        $("#sidebarCollapse").on('click', function () {
                            $("#sidebar").toggleClass('active');
                        });
                    });
                </script>
    </main>
</body>

</html>