<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH . "header.php");
// Variables
$anio_inicio = date('Y');
$mes_inicio = date('m') -1;
$prefijo = 'adj_';
$path_respositorio = dirname(__FILE__, 3) . '/repositorio/';
$resultado = '';
// Variables de POST
$idusuario = $_SESSION["idusuario"];
$idgestion = $_SESSION["idgestion"];
// Obtengo los datos de la gestión del usuario
try {
    $select_stmt = $db->prepare("SELECT * FROM gestiones WHERE idgestion=:idgestion");
    $select_stmt->bindParam(":idgestion", $idgestion);
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
$gestiones = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
$idgestion = $gestiones[0]['idgestion'];
$nombregestion = $gestiones[0]['descripcion'];
// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    // Instancio un objeto tipo datetime para obtener el Timestamp
    $fecha = new DateTime();
    // Nombre de archivo temporal
    $archivo_tmp_nombre = $_FILES['archivo']['tmp_name'];
    // Obtengo extension de archivo temporal
    $archivo_tmp_ext = strtolower(pathinfo($_FILES["archivo"]["name"], PATHINFO_EXTENSION));
    // Genero nombre de archivo final con nombre único
    $nombrearchivo = $prefijo . uniqid() . $fecha->getTimestamp() . '.' . $archivo_tmp_ext;
    $anio = (isset($_POST['txtAnio']) ? $_POST['txtAnio'] : $resultado .= 'No se registro año.');
    $mes = (isset($_POST['txtMes']) ? $_POST['txtMes'] : $resultado .= 'No se registro mes.');
    $descripcion = (isset($_POST['txtDescripcion']) ? $_POST['txtDescripcion'] : $resultado .= 'No se registro descripción de adjunto.');

    // Consulto si es un adjunto duplicado
    try {
        $sql_stmt = $db->prepare("SELECT * FROM archivos ar INNER JOIN adjuntos ad ON ar.idarchivo=ad.idarchivo WHERE anio=:anio AND mes=:mes AND ad.descripcion=:descripcion;");
        $sql_stmt->bindParam(":descripcion", $descripcion);
        $sql_stmt->bindParam(":anio", $anio);
        $sql_stmt->bindParam(":mes", $mes);
        // Ejecución de la consulta
        $sql_stmt->execute();
    } catch (Exception $ex) {
        $resultado .= $ex->getMessage();
    }
    // Transfiero datos de la consulta en la variable $datos
    $datos = $sql_stmt->fetchAll(PDO::FETCH_ASSOC);
    if (count($datos) == 0) {
        if ($archivo_tmp_nombre != '') {
            move_uploaded_file($archivo_tmp_nombre, $path_respositorio . $nombrearchivo);
        } else {
            $resultado .= 'Error, no se pudo subir el archivo al repositorio.';
        }
        // Inserto datos en tabla archivos
        try {
            $insert_stmt = $db->prepare("INSERT INTO archivos (idarchivo, nombrearchivo, anio, mes, fechahoracarga, estado) VALUES (NULL, :nombrearchivo, :anio, :mes, now(), 0);");
            //Parametros de inserción
            $insert_stmt->bindParam(":nombrearchivo", $nombrearchivo);
            $insert_stmt->bindParam(":anio", $anio);
            $insert_stmt->bindParam(":mes", $mes);
            // Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Inserto datos en tabla adjuntos
        try {
            $insert_stmt = $db->prepare("INSERT INTO adjuntos (idadjunto, idusuario, idgestion, idarchivo, descripcion, fechamodificacion, estado) 
            VALUES (NULL, :idusuario, :idgestion, (SELECT MAX(idarchivo) from archivos), :descripcion, now(), 0)");
            //Parametros de inserción
            $insert_stmt->bindParam(":idgestion", $idgestion);
            $insert_stmt->bindParam(":idusuario", $idusuario);
            $insert_stmt->bindParam(":descripcion", $descripcion);
            //Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Verifica la inserción correcta y carga del archivo
        if ($insert_stmt) {
            $resultado .= "Archivo cargado exitosamente.";
        }
        // Imprime los resultados del proceso de carga
        echo '<div class="alert alert-success">' . $resultado . '</div>';
    } else {
        $resultado .= "ERROR: El adjunto ya existe, favor verificar.";
        // Imprime los resultados del proceso de carga
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>
<div class="card">
    <div class="card-header">
        <h4>Subir archivo adjunto</h4>
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label class="form-label" for="txtGestion">Gestión</label>
                <input type="text" id="txtGestion" name="txtGestion" class="form-control"
                    value="<?php echo $nombregestion; ?>" disabled />
                <input type="hidden" id="txtIdGestion" name="txtIdGestion" value="<?php echo $idgestion; ?>" />
            </div>
            <div class="mb-3">
                <label for="txtAnio" class="form-label">Año</label>
                <select class="form-select form-select-lg" name="txtAnio" id="txtAnio">
                    <?php
                    for ($i = 1; $i <= 5; $i++) {                        
                        ?>
                        <option value="<?php echo $anio_inicio; ?>"><?php echo $anio_inicio; ?></option>
                        <?php
                        $anio_inicio--;
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="txtMes" class="form-label">Mes</label>
                <select class="form-select form-select-lg" name="txtMes" id="txtMes">
                    <?php
                    for ($i = 1; $i <= 12; $i++) {
                        if ($i == $mes_inicio) {
                            ?>
                            <option value="<?php echo $i; ?>" selected><?php echo GetNombreMes($i); ?></option>
                            <?php
                        } else {
                            ?>
                            <option value="<?php echo $i; ?>"><?php echo GetNombreMes($i); ?></option>
                            <?php
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtDescripcion">Descripcion</label>
                <input multiple type="text" id="txtDescripcion" name="txtDescripcion" class="form-control"
                    placeholder="Ingrese descripcion del adjunto" maxlength="250" style="text-transform:uppercase;"
                    onkeyup="javascript:this.value=this.value.toUpperCase();" required />
            </div>
            <div class="mb-3">
                <label class="form-label" for="archivo">Archivo</label>
                <input type="file" class="form-control" id="archivo" name="archivo" accept=".rar, .zip, .pdf" required>
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Subir adjunto</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<?php
include_once(TEMPLATE_PATH . "footer.php");
?>