<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
// Variables
$anio_inicio = date('Y') - 5;
$prefijo = 'adj_';
$path_respositorio = dirname(__FILE__, 3) . '/repositorio/';
$resultado = '';
// Variables de SESSION
$idusuario = $_SESSION["idusuario"];
// Variables de POST
$idadjunto = $_GET["idadjunto"];
// Obtengo datos del formulario
try {
    $select_stmt = $db->prepare("SELECT g.descripcion as gestion, ad.descripcion, ar.idarchivo, ar.nombrearchivo, anio, mes, ad.estado 
        FROM adjuntos ad INNER JOIN archivos ar ON ad.idarchivo=ar.idarchivo INNER JOIN gestiones g on ad.idgestion=g.idgestion WHERE ad.idadjunto =:idadjunto");
    $select_stmt->bindParam(":idadjunto", $idadjunto);
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
// Transfiero datos de la consulta en la variable $datos
$datos = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
// Organizo variables
$nombregestion = $datos[0]['gestion'];
$descripcion = $datos[0]['descripcion'];
$idarchivo = $datos[0]['idarchivo'];
$nombrearchivo = $datos[0]['nombrearchivo'];
$anio_orig = $datos[0]['anio'];
$mes_orig = $datos[0]['mes'];
$estado_adj = $datos[0]['estado'];
// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    // Instancio un objeto tipo datetime para obtener el Timestamp
    $fecha = new DateTime();
    // Obtengo variables de POST actualizadas
    $anio = (isset($_POST['txtAnio']) ? $_POST['txtAnio'] : $resultado .= 'No se registro año.');
    $mes = (isset($_POST['txtMes']) ? $_POST['txtMes'] : $resultado .= 'No se registro mes.');
    $descripcion = (isset($_POST['txtDescripcion']) ? $_POST['txtDescripcion'] : $resultado .= 'No se registro descripción de adjunto.');

    // Consulto si es un adjunto duplicado
    try {
        $sql_stmt = $db->prepare("SELECT * FROM archivos ar INNER JOIN adjuntos ad ON ar.idarchivo=ad.idarchivo WHERE anio=:anio AND mes=:mes 
            AND ad.descripcion=:descripcion AND idadjunto<>:idadjunto;");
        $sql_stmt->bindParam(":idadjunto", $idadjunto);
        $sql_stmt->bindParam(":descripcion", $descripcion);
        $sql_stmt->bindParam(":anio", $anio);
        $sql_stmt->bindParam(":mes", $mes);
        // Ejecución de la consulta
        $sql_stmt->execute();
    } catch (Exception $ex) {
        $resultado .= $ex->getMessage();
    }
    // Transfiero datos de la consulta en la variable $datos
    $datos = $sql_stmt->fetchAll(PDO::FETCH_ASSOC);
    // Comprueba si adjunto no existe en la base de datos
    if (count($datos) == 0) {
        // Obtengo archivo temporal
        $archivo_tmp_nombre = $_FILES['archivo']['tmp_name'];
        // Verifico si existe cambio de archivo
        if ($archivo_tmp_nombre != '') {
            // Obtengo extensiones original y nueva
            $ext_original = strtolower(pathinfo($nombrearchivo, PATHINFO_EXTENSION));
            $ext_nueva = strtolower(pathinfo($_FILES["archivo"]["name"], PATHINFO_EXTENSION));
            // Si es otro tipo de archivo el nombre de archivo se actualiza
            if ($ext_original <> $ext_nueva) {
                // Elimino el archivo original del repositorio
                unlink($path_respositorio . $nombrearchivo);
                // Cambio la extension del archivo                
                $nombrearchivo = str_replace($ext_original, $ext_nueva, $nombrearchivo);
                // Se graba el nuevo archivo
                move_uploaded_file($archivo_tmp_nombre, $path_respositorio . $nombrearchivo);
                // Imprimo resultado
                $resultado .= '<div class="alert alert-warning">ALERTA: Se ha cambiado el tipo de archivo, 
                    deberá actualizar el link en la matriz correspondiente.</div>';
                // Reverso el estado de adjunto a borrador
                $estado_adj = 0;
            } else {
                move_uploaded_file($archivo_tmp_nombre, $path_respositorio . $nombrearchivo);
            }
        }
        // Actualizo datos en tabla archivos
        try {
            $insert_stmt1 = $db->prepare("UPDATE archivos SET nombrearchivo=:nombrearchivo, anio=:anio, mes=:mes 
                WHERE idarchivo=:idarchivo;");
            //Parametros de inserción
            $insert_stmt1->bindParam(":idarchivo", $idarchivo);
            $insert_stmt1->bindParam(":nombrearchivo", $nombrearchivo);
            $insert_stmt1->bindParam(":anio", $anio);
            $insert_stmt1->bindParam(":mes", $mes);
            // Ejecución de la consulta
            $insert_stmt1->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Actualizo datos en tabla adjuntos
        try {
            $insert_stmt2 = $db->prepare("UPDATE adjuntos SET idusuario=:idusuario, descripcion=:descripcion, 
                fechamodificacion=now(), estado=:estado WHERE idadjunto=:idadjunto;");
            //Parametros de inserción
            $insert_stmt2->bindParam(":idusuario", $idusuario);
            $insert_stmt2->bindParam(":idadjunto", $idadjunto);
            $insert_stmt2->bindParam(":descripcion", $descripcion);
            $insert_stmt2->bindParam(":estado", $estado_adj);
            //Ejecución de la consulta
            $insert_stmt2->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Verifica la inserción correcta en base de datos
        if ($insert_stmt1 && $insert_stmt2) {
            $resultado .= "Registro actualizado exitosamente.";
        } else {
            $resultado .= "ERROR: Fallo al registrar en base de datos.";
        }
        // Imprime los resultados del proceso de carga
        echo '<div class="alert alert-success">' . $resultado . '</div>';
    } else {
        $resultado .= "ERROR: El adjunto ya existe, favor verificar.";
        // Imprime los resultados del proceso de carga
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>

<div class="card">
    <div class="card-header">
        Editar archivo adjunto
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label class="form-label" for="txtGestion">Gestión</label>
                <input type="text" id="txtGestion" name="txtGestion" class="form-control"
                    value="<?php echo $nombregestion; ?>" disabled />
            </div>
            <div class="mb-3">
                <label for="txtAnio" class="form-label">Año</label>
                <select class="form-select form-select-lg" name="txtAnio" id="txtAnio">
                    <?php
                    for ($i = 1; $i <= 5; $i++) {
                        $anio_inicio++;
                        if ($anio_inicio == $anio_orig) {
                            ?>
                            <option value="<?php echo $anio_inicio; ?>" selected><?php echo $anio_inicio; ?></option>
                            <?php
                        } else {
                            ?>
                            <option value="<?php echo $anio_inicio; ?>"><?php echo $anio_inicio; ?></option>
                            <?php
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="txtMes" class="form-label">Mes</label>
                <select class="form-select form-select-lg" name="txtMes" id="txtMes">
                    <?php
                    for ($i = 1; $i <= 12; $i++) {
                        if ($i == $mes_orig) {
                            ?>
                            <option value="<?php echo $i; ?>" selected><?php echo GetNombreMes($i); ?></option>
                            <?php
                        } else {
                            ?>
                            <option value="<?php echo $i; ?>"><?php echo GetNombreMes($i); ?></option>
                            <?php
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtDescripcion">Descripcion</label>
                <input multiple type="text" id="txtDescripcion" name="txtDescripcion" class="form-control"
                    placeholder="Ingrese descripcion del adjunto" maxlength="250" value="<?php echo $descripcion; ?>"
                    style="text-transform:uppercase;" onkeyup="javascript:this.value=this.value.toUpperCase();"
                    required />
            </div>
            <div class="mb-3">
                <label class="form-label" for="archivo">Archivo</label>
                <input type="file" class="form-control" id="archivo" name="archivo" accept=".rar, .zip, .pdf">
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Actualizar adjunto</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<?php
include_once (TEMPLATE_PATH."footer.php");
?>