<?php
// Direccionamiento dinámico (Obligatorio)
include_once($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once(TEMPLATE_PATH . "header.php");
// Variables
$prefijo = 'fmt_';
$path_respositorio = ROOT_PATH . 'repositorio/';
$resultado = '';
// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    // Instancio un objeto tipo datetime para obtener el Timestamp
    $fecha = new DateTime();
    $anio = date("Y");
    $mes = date("m");
    // Nombre de archivo temporal
    $archivo_tmp_nombre = $_FILES['archivo']['tmp_name'];
    // Obtengo extension de archivo temporal
    $archivo_tmp_ext = strtolower(pathinfo($_FILES["archivo"]["name"], PATHINFO_EXTENSION));
    // Genero nombre de archivo final con nombre único
    $nombrearchivo = $prefijo . uniqid() . $fecha->getTimestamp() . '.' . $archivo_tmp_ext;
    $observaciones = (isset($_POST['txtObservaciones']) && $_POST['txtObservaciones'] != '' ? $_POST['txtObservaciones'] : 'Ninguna');
    $iddescripmat = (isset($_POST['idDescripmatriz']) ? $_POST['idDescripmatriz'] : $resultado .= 'No se registro iddescripmat.');
    // Carga de archivo físico
    if ($archivo_tmp_nombre != '') {
        move_uploaded_file($archivo_tmp_nombre, $path_respositorio . $nombrearchivo);
    } else {
        $resultado .= 'Error, no se pudo subir el archivo al repositorio.';
    }
    // Inserto datos en tabla archivos
    try {
        $insert_stmt = $db->prepare("INSERT INTO archivos (idarchivo, nombrearchivo, anio, mes, fechahoracarga, estado) 
            VALUES (NULL, :nombrearchivo, :anio, :mes, NOW(), 1)");
        // Parametros de inserción
        $insert_stmt->bindParam(":nombrearchivo", $nombrearchivo);
        $insert_stmt->bindParam(":anio", $anio);
        $insert_stmt->bindParam(":mes", $mes);
        // Ejecución de la consulta
        $insert_stmt->execute();
    } catch (Exception $ex) {
        $resultado .= $ex->getMessage();
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
    // Inserto datos en tabla adjuntos
    try {
        $insert_stmt = $db->prepare("INSERT INTO formatos (idformato, iddescripmat, idarchivo, fecha, observacion, estado) 
        VALUES (NULL, :iddescripmat, (SELECT MAX(idarchivo) from archivos), now(), :observacion, 1)");
        //Parametros de inserción
        $insert_stmt->bindParam(":iddescripmat", $iddescripmat);
        $insert_stmt->bindParam(":observacion", $observaciones);
        //Ejecución de la consulta
        $insert_stmt->execute();
    } catch (Exception $ex) {
        $resultado .= 'Error al insertar en tabla formatos (' . $iddescripmat . '): ' . $ex->getMessage();
    }
    // Verifica la inserción correcta y carga del archivo
    if ($insert_stmt) {
        $resultado .= "Archivo cargado exitosamente.";
    }    
    // Imprime los resultados del proceso de carga
    echo '<div class="alert alert-success">' . $resultado . '</div>';
}
// Obtengo lista de select de matrices
try {
    $select_stmt = $db->prepare("SELECT dm.iddescripmat, CONCAT(abrev,') ', descripcion) AS matriz
        FROM descrip_matriz dm LEFT JOIN formatos f ON dm.iddescripmat=f.iddescripmat 
        WHERE dm.estado=1 AND f.idformato IS NULL ORDER BY dm.orden");
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
    exit;
}
$matrices = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="card">
    <div class="card-header">
        <h4>Agregar formato de matriz</h4>
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">

            <div class="mb-3">
                <label for="idDescripmatriz" class="form-label">Matriz:</label>
                <select class="form-select form-select-lg" name="idDescripmatriz" id="idDescripmatriz" required>
                    <option value="" selected>Seleccione una matriz</option>
                    <?php
                    foreach ($matrices as $m) {
                        ?>
                        <option value="<?php echo $m['iddescripmat']; ?>"><?php echo $m['matriz']; ?></option>
                        <?php
                    }
                    ?>
                </select>
            </div>

            <div class="mb-3">
                <label class="form-label" for="archivo">Archivo:</label>
                <input type="file" class="form-control" id="archivo" name="archivo" accept=".xls, .xlsx, .doc, .docx"
                    required>
            </div>

            <div class="mb-3">
                <label class="form-label" for="txtObservaciones">Observaciones:</label>
                <input multiple type="text" id="txtObservaciones" name="txtObservaciones" class="form-control"
                    placeholder="Observaciones del formato" maxlength="250" />
            </div>

            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Agregar formato</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<?php
include_once(TEMPLATE_PATH . "footer.php");
?>