<?php
// Direccionamiento dinámico (Obligatorio)
include_once($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once(TEMPLATE_PATH . "header.php");
// Definición de variables
$prefijo = 'fmt_';
$path_respositorio = ROOT_PATH . 'repositorio/';
$resultado = '';
// Obtengo varibales de GET
$idformato = $_GET["idformato"];
// Obtengo los datos adicionales
try {
    $select_stmt = $db->prepare("SELECT dm.iddescripmat, CONCAT(abrev,') ', descripcion) AS matriz, f.idarchivo, a.nombrearchivo, f.observacion
        FROM descrip_matriz dm INNER JOIN formatos f ON dm.iddescripmat=f.iddescripmat INNER JOIN archivos a ON f.idarchivo=a.idarchivo 
        WHERE f.idformato=:idformato AND dm.estado=1");
    $select_stmt->bindParam(":idformato", $idformato);        
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
$matriz = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    // Instancio un objeto tipo datetime para obtener el Timestamp
    $fecha = new DateTime();
    // Obtengo el id del archivo a actualizar
    $idarchivo = $matriz[0]['idarchivo'];
    $observaciones = (isset($_POST['txtObservaciones']) && $_POST['txtObservaciones'] !='' ? $_POST['txtObservaciones'] : 'Ninguna');
    // Nombre de archivo temporal
    $archivo_tmp_nombre = $_FILES['archivo']['tmp_name'];
    // Obtengo extension de archivo temporal
    $archivo_tmp_ext = strtolower(pathinfo($_FILES["archivo"]["name"], PATHINFO_EXTENSION));
    // Genero nombre de archivo final con nombre único
    $nombrearchivo = $prefijo . uniqid() . $fecha->getTimestamp() . '.' . $archivo_tmp_ext;    
    // Carga de archivo físico
    if ($archivo_tmp_nombre != '') {
        // Elimino el archivo original del repositorio
        unlink($path_respositorio . $matriz[0]['nombrearchivo']);
        move_uploaded_file($archivo_tmp_nombre, $path_respositorio . $nombrearchivo);
    } else {
        $resultado .= 'Error, no se pudo subir el archivo al repositorio.';
    }
    // Actualizo datos en tabla archivos
    try {
        $update_stmt = $db->prepare("UPDATE archivos SET nombrearchivo=:nombrearchivo, fechahoracarga=NOW() WHERE idarchivo=:idarchivo");
        $update_stmt->bindParam(":idarchivo", $idarchivo);
        $update_stmt->bindParam(":nombrearchivo", $nombrearchivo);
        // Ejecución de la consulta
        $update_stmt->execute();
    } catch (Exception $ex) {
        $resultado .= $ex->getMessage();
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
    // Actualizo datos en tabla formato
    try {
        $update_stmt = $db->prepare("UPDATE formatos SET fecha=NOW(), observacion=:observacion WHERE idformato=:idformato");
        //Parametros de inserción        
        $update_stmt->bindParam(":observacion", $observaciones);
        $update_stmt->bindParam(":idformato", $idformato);
        //Ejecución de la consulta
        $update_stmt->execute();
    } catch (Exception $ex) {
        $resultado .= 'Error al insertar en tabla formatos: ' . $ex->getMessage();
    }
    // Verifica la inserción correcta y carga del archivo
    if ($update_stmt) {
        $resultado .= "Archivo cargado exitosamente.";
    }
    // Imprime los resultados del proceso de carga
    echo '<div class="alert alert-success">' . $resultado . '</div>';
}
?>
<div class="card">
    <div class="card-header">
        EDITAR FORMATO
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">

            <div class="mb-3">
                <label class="form-label" for="txtGestion">Matriz:</label>
                <input type="text" id="txtGestion" name="txtGestion" class="form-control"
                    value="<?php echo $matriz[0]['matriz']; ?>" disabled />
                <input type="hidden" id="idDescripmatriz" name="idDescripmatriz" value="<?php echo $matriz[0]['iddescripmat']; ?>" />
            </div>            

            <div class="mb-3">
                <label class="form-label" for="archivo">Archivo:</label>
                <input type="file" class="form-control" id="archivo" name="archivo" accept=".xls, .xlsx, .doc, .docx">                
            </div>

            <div class="mb-3">
                <label class="form-label" for="txtObservaciones">Observaciones:</label>
                <input multiple type="text" id="txtObservaciones" name="txtObservaciones" class="form-control"
                    placeholder="Observaciones del formato" maxlength="250" value="<?php echo $matriz[0]['observacion']; ?>"/>
            </div>

            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Actualizar formato</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<?php
include_once(TEMPLATE_PATH . "footer.php");
?>