<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'].'/sislotaip/dir.php');
include_once (TEMPLATE_PATH . "header.php");
include_once (INCLUDES_PATH . "funciones.php");
// Variables de session
$nombre = $_SESSION["nombre"];
$privilegios = $_SESSION["privilegios"];
$idusuario = $_SESSION["idusuario"];
$aprobador = $_SESSION["aprobador"];
$idgestion = $_SESSION["idgestion"];
$estado_aprobador = $_SESSION["estado_aprobador"];

// Definicion de variables
$anio_inicio_produccion = date("Y", strtotime($fecha_inicio_produccion));
$mes_inicio_produccion = date("m", strtotime($fecha_inicio_produccion));
$reporte_mpg = '';
$reporte_pr = '';
// Clasificacion de resumen inicial por usuario
// 0: Operador
// 1: Responsable
// 2: Responsable + Miembro Comisión
// 3: Administrador
switch ($privilegios) {
    case 0: {
            // Usuario Operador
            $sql_revision = "SELECT CONCAT(abrev,') ',dm.descripcion) AS descripcion, ar.anio, ar.mes, g.descripcion AS gestion
                FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat
                INNER JOIN usuarios u ON m.idusuario=u.idusuario
                INNER JOIN gestiones g ON dm.idgestion=g.idgestion
                INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo    
                WHERE m.estado=2 AND m.idusuario=:idusuario AND dm.estado=1 ORDER BY dm.orden ASC";
            $link_pend_rev = $url_base . "secciones/matrices/index.php";
        }
        break;
    case 1: {
            // Usuario Responsable + Aprobador
            if ($aprobador == true && $estado_aprobador == 1) {
                $sql_revision = "SELECT CONCAT(abrev,') ',dm.descripcion) AS descripcion, ar.anio, ar.mes, g.descripcion AS gestion
                    FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat
                    INNER JOIN usuarios u ON m.idusuario=u.idusuario
                    INNER JOIN gestiones g ON dm.idgestion=g.idgestion
                    INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo
                    WHERE dm.orden <> 0 AND dm.estado=1 
                        AND m.idmatriz NOT IN (SELECT idmatriz FROM revisiones r INNER JOIN miembros_comision mc ON r.idmiembro_comision=mc.idmiembro_comision WHERE mc.idusuario=:idusuario) 
                        AND m.estado <> 2 AND m.fechamodificacion > (SELECT f_inicio_gestion FROM miembros_comision WHERE aprobador=1 AND estado=1 AND idusuario=:idusuario)";
                $link_pend_rev = $url_base . "secciones/revision/index.php";

            } else {
                $sql_revision = "SELECT CONCAT(abrev,') ',dm.descripcion) AS descripcion, ar.anio, ar.mes, g.descripcion AS gestion
                    FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat
                    INNER JOIN usuarios u ON m.idusuario=u.idusuario
                    INNER JOIN gestiones g ON dm.idgestion=g.idgestion
                    INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo
                    WHERE m.estado = 2 AND m.idusuario=:idusuario AND dm.estado=1";
                $link_pend_rev = $url_base . "secciones/matrices/index.php";
            }
        }
        break;
    case 2: {
            // Usuario Administrador
            if ($aprobador == true && $estado_aprobador == 1) {
                $sql_revision = "SELECT CONCAT(abrev,') ',dm.descripcion) AS descripcion, ar.anio, ar.mes, g.descripcion AS gestion
                    FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat
                    INNER JOIN usuarios u ON m.idusuario=u.idusuario
                    INNER JOIN gestiones g ON dm.idgestion=g.idgestion
                    INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo
                    INNER JOIN miembros_comision mic ON mic.idusuario=u.idusuario
                    WHERE dm.orden <> 0 AND dm.estado=1 AND m.idmatriz NOT IN (SELECT idmatriz FROM revisiones r INNER JOIN miembros_comision mc ON 
                    r.idmiembro_comision=mc.idmiembro_comision WHERE mc.idusuario=:idusuario)";
                $link_pend_rev = $url_base . "secciones/revision/index.php";

            } else {
                $sql_revision = "SELECT CONCAT(abrev,') ',dm.descripcion) AS descripcion, ar.anio, ar.mes, g.descripcion AS gestion
                    FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat
                    INNER JOIN usuarios u ON m.idusuario=u.idusuario
                    INNER JOIN gestiones g ON dm.idgestion=g.idgestion
                    INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo    
                    WHERE $dm.estado=1 AND m.estado = 2 AND m.idusuario=:idusuario ORDER BY dm.orden ASC";
                $link_pend_rev = $url_base . "secciones/matrices/index.php";
            }
        }
        break;
    case 3: {
            // Usuario Superadministrador
            if ($aprobador == true && $estado_aprobador == 1) {
                $sql_revision = "SELECT CONCAT(abrev,') ',dm.descripcion) AS descripcion, ar.anio, ar.mes, g.descripcion AS gestion
                    FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat
                    INNER JOIN usuarios u ON m.idusuario=u.idusuario
                    INNER JOIN gestiones g ON dm.idgestion=g.idgestion
                    INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo    
                    WHERE dm.orden <> 0 AND dm.estado=1 AND m.idmatriz NOT IN (SELECT idmatriz FROM revisiones r INNER JOIN miembros_comision mc ON 
                    r.idmiembro_comision=mc.idmiembro_comision WHERE mc.idusuario=:idusuario)";
                $link_pend_rev = $url_base . "secciones/revision/index.php";

            } else {
                $sql_revision = "SELECT CONCAT(abrev,') ',dm.descripcion) AS descripcion, ar.anio, ar.mes, g.descripcion AS gestion
                FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat
                INNER JOIN usuarios u ON m.idusuario=u.idusuario
                INNER JOIN gestiones g ON dm.idgestion=g.idgestion
                INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo    
                WHERE dm.estado=1 AND m.estado = 2 AND m.idusuario=:idusuario ORDER BY dm.orden ASC";
                $link_pend_rev = $url_base . "secciones/matrices/index.php";
            }
        }
        break;
}
// Obtengo pendientes de revision
try {
    $select_stmt = $db->prepare($sql_revision);
    $select_stmt->bindParam(":idusuario", $idusuario);
    $select_stmt->execute();
} catch (PDOException $e) {
    echo $e->getMessage();
}
$pendientes_rev = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
// Armo reporte pendientes por revision
$reporte_pr .= "
    <table class='table' id='tabla_id'>
    <thead>
        <th>Año</th>
        <th>Mes</th>
        <th>Matriz</th>
        <th>Gestion</th>
    </thead>
        ";
foreach ($pendientes_rev as $pr) {
    $reporte_pr .=
        "<tr>
            <td>" . $pr['anio'] . "</td>
            <td>" . GetNombreMes($pr['mes']) . "</td>
            <td>" . $pr['descripcion'] . "</td>
            <td>" . $pr['gestion'] . "</td>
        </tr>";
}
$reporte_pr .= "</table>";
// Obtengo las matrices pendientes por cumplir
$matrices_pendientes_cumplimiento = GetMatricesPendientes($anio_inicio_produccion, $mes_inicio_produccion-1, $idgestion);
// Armo reporte de matrices pendientes de cumplir
$reporte_mpg .= "
    <table class='table' id='tabla_id'>
    <thead>
        <th>Año</th>
        <th>Mes</th>
        <th>Matriz</th>
    </thead>
        ";
foreach ($matrices_pendientes_cumplimiento as $mpc) {
    $reporte_mpg .=
        "<tr>
            <td>" . $mpc['anio'] . "</td>
            <td>" . GetNombreMes($mpc['mes']) . "</td>
            <td>" . $mpc['abrev'] . ') ' . $mpc['descripcion'] . "</td>
        </tr>";
}
$reporte_mpg .= "</table>";
?>
<div class="content-wrapper">
    <div class="alert alert-secondary">
        <div class="row">
            <h3>Sistema de cumplimiento LOTAIP</h3>
            <h5>Bienvenido(a),
                <?php echo $nombre; ?>
            </h5>
            <h6>Fecha Producción:
                <?php echo $fecha_inicio_produccion; ?>
            </h6>
            <h8><i class="fa-solid fa-user"></i>
                Rol:
                <?php echo GetRol($privilegios); ?>
            </h8>
            <div>
                <hr style="color: grey;" />
            </div>
        </div>
        <div class="row">
            <div class="col-sm-6">
                <div class="card <?php echo ($privilegios > 0 && $privilegios < 2) ?: 'd-none'; ?>">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fa-solid fa-list-check"></i> Pendientes de cumplimiento</h5>
                        <p class="card-text">Usted tiene <strong>
                                <?php echo "(" . count($matrices_pendientes_cumplimiento) . ")"; ?>
                            </strong> matrices que debe cumplir.</p>
                        <!-- Boton Ver matrices pendientes -->
                        <button class="btn btn-primary" data-bs-toggle='modal' data-bs-target='#modalVentana'
                            data-bs-titulo="Reporte de matrices por cumplir "
                            data-bs-reporte="<?php echo $reporte_mpg; ?>">Ver
                            <i class="fa-solid fa-magnifying-glass"></i></button>
                        <!-- Boton Cumplir matrices pendientes -->
                        <a href="<?php echo $url_base . "secciones/matrices/index.php"; ?>"
                            class="btn btn-success">Cumplir <i class="fa-solid fa-check"></i></a>
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="card <?php echo ($aprobador == 1 && $estado_aprobador == 1) ?: 'd-none'; ?>">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fa-solid fa-clipboard-list"></i> Pendientes de revisión</h5>
                        <p class="card-text">Usted tiene <strong>
                                <?php echo "(" . count($pendientes_rev) . ")"; ?>
                            </strong> matrices que requieren su atención.</p>
                        <button class="btn btn-primary" data-bs-toggle='modal' data-bs-target='#modalVentana'
                            data-bs-titulo="Reporte de pendientes de revision"
                            data-bs-reporte="<?php echo $reporte_pr; ?>">Ver
                            <i class="fa-solid fa-magnifying-glass"></i></button>
                        <a href="<?php echo $link_pend_rev; ?>" class="btn btn-success">Revisar <i
                            class="fa-solid fa-check"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Ventana -->
    <div class="modal fade" id="modalVentana" tabindex="-1" aria-labelledby="modalVentanaLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalVentanaLabel">Listado de matrices por cumplir</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info" id="estadoModal" name="estadoModal"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>

</div>

<!-- Mostrar ventanas modales -->
<script>
    var modalVentana = document.getElementById('modalVentana');
    modalVentana.addEventListener('show.bs.modal', function (event) {
        // Button that triggered the modal
        var button = event.relatedTarget;
        // Extract info from data-bs-* attributes        
        var titulo = button.getAttribute('data-bs-titulo');
        var reporte = button.getAttribute('data-bs-reporte');
        // Set info        
        var modalBodyInput = modalVentana.querySelector('.modal-body #estadoModal');
        var modalTitle = modalVentana.querySelector('.modal-title');
        modalBodyInput.innerHTML = reporte;
        modalTitle.textContent = titulo;
  });
</script>

</div>
<?php
require_once (TEMPLATE_PATH."footer.php");
?>