<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH . "header.php");
// Variables
$anio_inicio = date('Y');
$mes_inicio = date('m') - 1;
$prefijo = 'mat_';
$path_respositorio = dirname(__FILE__, 3) . '/repositorio/';
$resultado = '';

// Variables de SESSION
$idusuario = $_SESSION["idusuario"];
$idgestion = $_SESSION["idgestion"]; // id gestion: Responsable LOTAIP = 
$nombregestion = $_SESSION["gestion"];

// Obtengo los datos adicionales
try {
    $select_stmt = $db->prepare("SELECT *, CONCAT(abrev,') ', descripcion) AS matriz FROM descrip_matriz 
        WHERE idgestion=:idgestion AND estado=1 ORDER BY orden ASC");
    $select_stmt->bindParam(":idgestion", $idgestion);
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
$matrices = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    // Instancio un objeto tipo datetime para obtener el Timestamp
    $fecha = new DateTime();
    // Nombre de archivo temporal
    $archivo_tmp_nombre = $_FILES['archivo']['tmp_name'];
    // Obtengo extension de archivo temporal
    $archivo_tmp_ext = strtolower(pathinfo($_FILES["archivo"]["name"], PATHINFO_EXTENSION));
    // Genero nombre de archivo final con nombre único
    $nombrearchivo = $prefijo . uniqid() . $fecha->getTimestamp() . '.' . $archivo_tmp_ext;
    $anio = (isset($_POST['txtAnio']) ? $_POST['txtAnio'] : $resultado .= 'No se registro año.');
    $mes = (isset($_POST['txtMes']) ? $_POST['txtMes'] : $resultado .= 'No se registro mes.');
    $iddescripmat = (isset($_POST['idDescripmatriz']) ? $_POST['idDescripmatriz'] : $resultado .= 'No se registro descripción de adjunto.');
    // Consulto si es una matriz duplicada
    try {
        $sql_stmt = $db->prepare("SELECT * FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat 
            INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo WHERE anio=:anio AND mes=:mes AND m.iddescripmat=:iddescripmat");
        $sql_stmt->bindParam(":anio", $anio);
        $sql_stmt->bindParam(":mes", $mes);
        $sql_stmt->bindParam(":iddescripmat", $iddescripmat);
        // Ejecución de la consulta
        $sql_stmt->execute();
    } catch (Exception $ex) {
        $resultado .= $ex->getMessage();
    }
    // Transfiero datos de la consulta en la variable $datos
    $datos = $sql_stmt->fetchAll(PDO::FETCH_ASSOC);
    if (count($datos) == 0) {        
        // Matriz con orden 0 :: Plantillas LOTAIP 2024
        // Plantillas LOTAIP 2024 se publican directamente
        for($i=0; $i<count($matrices);$i++){
            if($matrices[$i]['iddescripmat'] == $iddescripmat){
                $orden = $matrices[$i]['orden'];
            }
        }
        if($orden == '0'){
            $estado_publicado = 3;
        } else{
            $estado_publicado = 0;
        }
        // Carga de archivo
        if ($archivo_tmp_nombre != '') {
            move_uploaded_file($archivo_tmp_nombre, $path_respositorio . $nombrearchivo);
        } else {
            $resultado .= 'Error, no se pudo subir el archivo al repositorio.';
        }
        // Inserto datos en tabla archivos
        try {
            $insert_stmt = $db->prepare("INSERT INTO archivos (idarchivo, nombrearchivo, anio, mes, fechahoracarga, estado) 
            VALUES (NULL, :nombrearchivo, :anio, :mes, NOW(), 1)");
            //Parametros de inserción
            $insert_stmt->bindParam(":nombrearchivo", $nombrearchivo);
            $insert_stmt->bindParam(":anio", $anio);
            $insert_stmt->bindParam(":mes", $mes);
            // Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
            exit;
        }
        // Inserto datos en tabla matrices
        try {
            $insert_stmt = $db->prepare("INSERT INTO matrices (idmatriz, idusuario, iddescripmat, idarchivo, fechamodificacion, estado) 
            VALUES (NULL, :idusuario, :iddescripmat, (SELECT MAX(idarchivo) FROM archivos), NOW(), :estado_publicado)");
            //Parametros de inserción
            $insert_stmt->bindParam(":idusuario", $idusuario);
            $insert_stmt->bindParam(":iddescripmat", $iddescripmat);
            $insert_stmt->bindParam(":estado_publicado", $estado_publicado);
            //Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Verifica la inserción correcta y carga del archivo
        if ($insert_stmt) {
            $resultado .= "Archivo cargado exitosamente.";
            // Consulta de idmatriz insertada para envio de notificacion
            try {
                $select_stmt = $db->prepare("SELECT MAX(idmatriz) as idmatriz FROM matrices");
                //Ejecución de la consulta
                $select_stmt->execute();
            } catch (Exception $ex) {
                $resultado .= $ex->getMessage();
            }
            $idmatriz = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
            // Envia notificaciones por correo electrónico
            if($nombregestion == "Responsable LOTAIP"){
                EnviarNotificacion($idmatriz[0]['idmatriz'], 1, DEBUG); // Envío notificacion estado publicado
            } else{
                EnviarNotificacion($idmatriz[0]['idmatriz'], 0, DEBUG); // Envío notificacion estado borrador
            }
        }
        // Imprime los resultados del proceso de carga
        echo '<div class="alert alert-success">' . $resultado . '</div>';
    } else {
        $resultado .= "ERROR: La matriz ya existe, favor verificar.";
        // Imprime los resultados del proceso de carga
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>
<div class="card">
    <div class="card-header">
        <h4>Agregar matriz</h4>
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">

            <div class="mb-3">
                <label class="form-label" for="txtGestion">Gestión</label>
                <input type="text" id="txtGestion" name="txtGestion" class="form-control"
                    value="<?php echo $nombregestion; ?>" disabled />
            </div>

            <div class="mb-3">
                <label for="idDescripmatriz" class="form-label">Matriz</label>
                <select class="form-select form-select-lg" name="idDescripmatriz" id="idDescripmatriz" required>
                    <?php
                    foreach ($matrices as $m) {
                        ?>
                        <option value="<?php echo $m['iddescripmat']; ?>">
                            <?php echo $m['matriz']; ?>
                        </option>
                        <?php
                    }
                    ?>
                </select>
            </div>

            <div class="mb-3">
                <label for="txtAnio" class="form-label">Año</label>
                <select class="form-select form-select-lg" name="txtAnio" id="txtAnio">
                    <?php
                    for ($i = 1; $i <= 5; $i++) {
                        ?>
                        <option value="<?php echo $anio_inicio; ?>">
                            <?php echo $anio_inicio; ?>
                        </option>
                        <?php
                        $anio_inicio--;
                    }
                    ?>
                </select>
            </div>

            <div class="mb-3">
                <label for="txtMes" class="form-label">Mes</label>
                <select class="form-select form-select-lg" name="txtMes" id="txtMes">
                    <?php
                    for ($i = 1; $i <= 12; $i++) {
                        if ($i == $mes_inicio) {
                            ?>
                            <option value="<?php echo $i; ?>" selected>
                                <?php echo GetNombreMes($i); ?>
                            </option>
                            <?php
                        } else {
                            ?>
                            <option value="<?php echo $i; ?>">
                                <?php echo GetNombreMes($i); ?>
                            </option>
                            <?php
                        }
                    }
                    ?>
                </select>
            </div>

            <div class="mb-3">
                <label class="form-label" for="archivo">Archivo</label>
                <input type="file" class="form-control" id="archivo" name="archivo" accept=".zip, .pdf" required>
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Agregar matriz</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<!---Validación de carga de archivos .zip--->
<script language='javascript'>
    $("#archivo").on("change", (e) => {
        const archivo = $(e.target)[0].files[0];        
        let nombArchivo = archivo.name;
        var extension = nombArchivo.split(".").slice(-1);
        extension = extension[0];
        let extensiones = ["zip", "pdf", "ZIP", "PDF"];
        if (extensiones.indexOf(extension) === -1) {
            alert("Error: Sólo se aceptan archivos con extensión zip y pdf.");
            const $elemento = document.querySelector("#archivo");
            $elemento.value = "";
        }
    });
</script>
<?php
include_once (TEMPLATE_PATH . "footer.php");
?>