<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (INCLUDES_PATH . 'funciones.php');

if (isset($_POST['anio']) && isset($_POST['mes'])) {
    // Obtengo variables de POST
    $anio = $_POST['anio'];
    $mes = $_POST['mes'];
    // Defino nombres de directorio temporal
    $dir_destino = TEMP_PATH . GetNombreMes($mes) . $anio . '/';
    $nom_zip = GetNombreMes($mes) . $anio . '.zip';
    // Creo directorio temporal de zip
    mkdir($dir_destino);
    // Comprimo archivos en zip
    ComprimirZip($dir_destino, $nom_zip, $anio, $mes);
    // Forzar descarga de archivo zip
    $zip_descarga = $dir_destino . $nom_zip;
    if (file_exists($zip_descarga)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/zip');
        header('Content-Disposition: attachment; filename=' . basename($zip_descarga));
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($zip_descarga));
        ob_clean();
        flush();
        readfile($zip_descarga);
    } else {
        $resultado = 'ZIP no disponible, consulte con la UPGE del RPMC.';
    }
    // Elimino los directorios y archivos temporales del directorio temp/
    EliminarTodo($dir_destino);
} else {
    $resultado = "No existen datos de anio" . $anio . " y mes " . $mes;
    echo json_encode($resultado);
}