<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH . "header.php");

// Obtengo variables de POST
$idgestion = $_SESSION["idgestion"];
$sentencia = "SELECT ROW_NUMBER() OVER (ORDER BY a.anio ASC, a.mes ASC) AS 'orden', a.anio, a.mes, count(a.idarchivo) as archivos
FROM archivos a INNER JOIN matrices m ON a.idarchivo=m.idarchivo 
	INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat
WHERE m.estado = 3 AND orden <> 0
GROUP BY a.anio, a.mes";

$registros = $db->prepare($sentencia);
$registros->execute();
?>
<form action="descargar.php" method="post">
    <div class="card">
        <div class="card-body">
            <div class="table-responsive-sm">
                <table class="table" id="tabla_id">
                    <thead>
                        <tr>
                            <th scope="col" width="10%">Orden</th>
                            <th scope="col" width="15%">Año</th>
                            <th scope="col" width="20%">Mes</th>
                            <th scope="col" width="20%">Número de Archivos</th>
                            <th scope="col" width="25%">Opciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $registros->fetch(PDO::FETCH_ASSOC)) {
                            ?>
                            <tr class="">
                                <td scope="row">
                                    <?php echo $row["orden"]; ?>
                                </td>
                                <td scope="row">
                                    <?php echo $row["anio"]; ?>
                                </td>
                                <td>
                                    <?php echo GetNombreMes($row["mes"]); ?>
                                </td>
                                <td>
                                    <?php echo $row["archivos"]; ?>
                                </td>
                                <td>
                                    <!-- Botón descargar -->
                                    <button class="btn btn-success" type="button"
                                        onclick='download(<?php echo $row["anio"]; ?>,
                                    <?php echo $row["mes"]; ?>,"<?php echo GetNombreMes($row["mes"]) . $row["anio"] . ".zip"; ?>")'>
                                        <i class="ion ion-md-download"></i> Descargar</button>
                                </td>
                            </tr>
                            <?php
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer text-muted">
            Descripción: Matrices que se publicarán en el apartado Transparencia.
        </div>
    </div>
</form>
<!-- Modal de vista de observaciones -->
<div class="modal fade" id="modalObservaciones" tabindex="-1" aria-labelledby="modalObservacionesLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalObservacionesLabel">Estado de matriz</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info" id="estadoModal" name="estadoModal"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<!--Validaciones y funciones JavaScript-->
<script language="javascript">
    function download(year, month, archivo) {
        $.ajax({
            type: 'POST',
            url: 'descargar.php',
            xhrFields: {
                responseType: 'blob'
            },
            data: {
                ajax: true,
                anio: year,
                mes: month,
            },
            success: function (json) {
                var a = document.createElement('a');
                var url = window.URL.createObjectURL(json);
                a.href = url;
                a.download = archivo;
                a.click();
                window.URL.revokeObjectURL(url);
            },
            error: function () {
                console.log("Error");
            }
        });
    }
</script>
<?php
include_once (TEMPLATE_PATH . "footer.php");
?>