<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
// Obtengo variables de POST
$idgestion = $_SESSION["idgestion"];
$sentencia = "SELECT ROW_NUMBER() OVER (ORDER BY m.estado DESC, ar.fechahoracarga) AS 'orden', CONCAT(abrev,') ', dm.descripcion) AS matriz, 
    m.idmatriz, ar.idarchivo, u.nombre AS nombreusuario, fechamodificacion, ar.nombrearchivo, ar.anio, ar.mes, ar.fechahoracarga AS fechacarga, 
    m.estado
    FROM matrices m INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat 
    INNER JOIN usuarios u ON m.idusuario=u.idusuario
    WHERE dm.idgestion=:idgestion";
$registros = $db->prepare($sentencia);
$registros->bindParam(":idgestion", $idgestion);
$registros->execute();
?>

<div class="card">
    <div class="card-header">
        <a name="" id="" class="btn btn-success" href="crear.php" role="button">Agregar matriz</a>
    </div>
    <div class="card-body">
        <div class="table-responsive-sm">
            <table class="table" id="tabla_id">
                <thead>
                    <tr>
                        <th scope="col" width="2%">Ord</th>
                        <th scope="col" width="2%">Estado</th>
                        <th scope="col" width="20%">Matriz</th>
                        <th scope="col" width="2%">Año</th>
                        <th scope="col" width="2%">Mes</th>
                        <th scope="col" width="8%">Fecha carga</th>
                        <th scope="col" width="8%">Fecha modificacion</th>
                        <th scope="col" width="8%">Usuario</th>
                        <th scope="col" width="20%">Opciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $registros->fetch(PDO::FETCH_ASSOC)) {
                        ?>
                        <tr class="">
                            <td scope="row">
                                <?php echo $row["orden"]; ?>
                            </td>
                            <td>
                                <?php echo GetEstadoMatriz($row["estado"], $row["idmatriz"]); ?>
                            </td>
                            <td>
                                <?php echo $row["matriz"]; ?>
                            </td>
                            <td>
                                <?php echo $row["anio"]; ?>
                            </td>
                            <td>
                                <?php echo GetnombreMes($row["mes"]); ?>
                            </td>
                            <td>
                                <?php echo $row["fechacarga"]; ?>
                            </td>
                            <td>
                                <?php echo $row["fechamodificacion"]; ?>
                            </td>
                            <td>
                                <?php echo $row["nombreusuario"]; ?>
                            </td>
                            <td>
                                <!-- Botón editar -->
                                <a
                                    class="btn btn-primary <?php echo ($row["estado"] == 0) ? 'active' : 'disabled'; ?>"
                                    href="editar.php?idmatriz=<?php echo $row["idmatriz"]; ?>" role="button">Editar <i
                                        class="fa-solid fa-edit"></i></a>
                                <!-- Botón eliminar -->
                                <button
                                    class="btn btn-danger <?php echo ($row["estado"] == 0 || $row["estado"] == 2) ? 'active' : 'disabled'; ?>"
                                    type="button" value="Eliminar"
                                    onclick='eliminar_archivo("<?php echo $row["idarchivo"]; ?>", "<?php echo $row["nombrearchivo"]; ?>")'>Eliminar <i
                                        class="fa fa-trash"></i></button>
                                <!-- Botón ver -->
                                <button class="btn btn-secondary" type="button" value="Ver"
                                    onclick='ver_pdf("<?php echo $row["nombrearchivo"]; ?>")'><i class="fa-solid fa-magnifying-glass"></i></button>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer text-muted">
        Descripción: Matrices que se publicarán en el apartado Transparencia.
    </div>
</div>

<!-- Modal de vista de observaciones -->
<div class="modal fade" id="modalObservaciones" tabindex="-1" aria-labelledby="modalObservacionesLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalObservacionesLabel">Estado de matriz</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info" id="estadoModal" name="estadoModal"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<!-- Mostrar modalObservaciones -->
<script>
    var modalObservaciones = document.getElementById('modalObservaciones')
    modalObservaciones.addEventListener('show.bs.modal', function (event) {
        // Button that triggered the modal
        var button = event.relatedTarget;
        // Extract info from data-bs-* attributes        
        var observaciones = button.getAttribute('data-bs-obs');
        // Update the modal's content.        
        var modalBodyInput = modalObservaciones.querySelector('.modal-body #estadoModal');
        modalBodyInput.innerHTML = observaciones;
    });
</script>

<!--Validaciones y funciones JavaScript-->
<script language="javascript">
    // Función para Eliminar registro
    const eliminar_archivo = async function (idarchivo, nombrearchivo) {
        // Preparamos el formdata
        var opcion = confirm("¿Esta seguro que desea eliminar éste registro?");
        if (opcion == true) {
            const formData = new FormData();
            // Enviamos por POST
            formData.append("idarchivo", idarchivo);
            formData.append("nombrearchivo", nombrearchivo);
            const respuestaRaw = await fetch("./eliminar.php", {
                method: "POST",
                body: formData,
            });
            const respuesta = await respuestaRaw.json();
            // Sacamos el resultado por consola
            console.log({ respuesta });
            window.location.reload();
        }
    };
    // Función para mostrar/descargar el archivo
    const ver_pdf = async function (nombrearchivo) {
        var protocolo = window.location.protocol + '//';
        var host = window.location.hostname;
        var path = window.location.pathname;
        var path_parts = path.split('/');
        var repositorio = '/' + path_parts[1] + '/repositorio/';
        var url = protocolo + host + repositorio + nombrearchivo;
        window.open(url, "_blank");
    };

</script>
<?php
include_once(TEMPLATE_PATH."footer.php");
?>