<?php
// Direccionamiento dinámico (Obligatorio)
include_once($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once(TEMPLATE_PATH . "header.php");
// Definicion de variables
$resultado = '';
// Obtengo lista de gestiones
try {
    $select_stmt = $db->prepare("SELECT idgestion, descripcion FROM gestiones WHERE estado=1");
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
// Transfiero datos de la consulta
$gestiones = $select_stmt->fetchAll(PDO::FETCH_ASSOC);

// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    $idgestion = (isset($_POST['txtGestion']) ? $_POST['txtGestion'] : $resultado .= 'No se ingresa txtGestion');
    $abrev = (isset($_POST['txtAbrev']) ? $_POST['txtAbrev'] : $resultado .= 'No se ingresa txtAbrev');
    $nombre = (isset($_POST['txtNombre']) ? $_POST['txtNombre'] : $resultado .= 'No se ingresa txtNombre');
    $orden = (isset($_POST['txtOrden']) ? $_POST['txtOrden'] : $resultado .= 'No se ingresa txtOrden');
    // Comparo que no sea registro duplicado    
    try {
        $select_stmt = $db->prepare("SELECT * FROM descrip_matriz WHERE (abrev=:abrev OR descripcion=:nombre) AND estado=1");
        $select_stmt->bindParam(":abrev", $abrev);
        $select_stmt->bindParam(":nombre", $nombre);        
        $select_stmt->execute();
    } catch (PDOException $e) {
        $resultado .= $e->getMessage();
    }
    // Transfiero datos de la consulta
    $matrices = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
    // Comprueba si adjunto no existe en la base de datos    
    if (count($matrices) == 0) {
        // Inserto datos en tabla
        try {
            $insert_stmt = $db->prepare("INSERT INTO descrip_matriz (iddescripmat, idgestion, abrev, descripcion, orden, estado) 
                VALUES (NULL, :idgestion, :abrev, :nombre, :orden, 1)");
            //Parametros de inserción
            $insert_stmt->bindParam(":idgestion", $idgestion);
            $insert_stmt->bindParam(":abrev", $abrev);
            $insert_stmt->bindParam(":nombre", $nombre);
            $insert_stmt->bindParam(":orden", $orden);
            // Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Verifica la inserción correcta y carga del archivo
        if ($resultado == '') {
            $resultado .= "Registro creado exitosamente.";
            // Imprime los resultados del proceso de carga
            echo '<div class="alert alert-success">' . $resultado . '</div>';
        } else {
            $resultado .= "Error al insertar el registro.";
            // Imprime los resultados del proceso de carga
            echo '<div class="alert alert-danger">' . $resultado . '</div>';
        }
    } else {
        $resultado = "ERROR: Registro duplicado.";
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>
<div class="card">
    <div class="card-header">
        <h4>Agregar descripción de Matriz</h4>
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="txtGestion" class="form-label">Gestión responsable:</label>
                <select class="form-select form-select-lg" name="txtGestion" id="txtGestion" required>
                    <option value="" selected>Seleccione una Gestión</option>
                    <?php
                    foreach ($gestiones as $g) {
                        ?>
                        <option value="<?php echo $g['idgestion']; ?>"><?php echo $g['descripcion']; ?></option>
                        <?php
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtAbrev">Literal o abreviatura:</label>
                <input type="text" id="txtAbrev" name="txtAbrev" class="form-control"
                    placeholder="Digite el literal de la matriz (Ej: a1)"
                    onkeyup="javascript:this.value=this.value.toLowerCase();" required />
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtNombre">Nombre de matriz:</label>
                <input type="text" id="txtNombre" name="txtNombre" class="form-control"
                    placeholder="Describa el nombre de la matriz" required />
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtOrden">Orden:</label>
                <input type="number" id="txtOrden" name="txtOrden" class="form-control"
                    placeholder="Digite el orden de aparición en el listado de matrices" required />
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Agregar descripción de Matriz</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<?php
include_once(TEMPLATE_PATH . "footer.php");
?>