<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
$registros = $db->prepare("SELECT dm.iddescripmat, abrev, dm.descripcion as nombre, g.descripcion as gestion, dm.orden 
    FROM descrip_matriz dm INNER JOIN gestiones g ON dm.idgestion=g.idgestion
    WHERE dm.estado = 1 ORDER BY dm.orden ASC");
$registros->execute();
?>
<!-- Mensaje de notificacion de transacción-->
<div class="mensaje alert alert-danger" style="display:none;" id="mensaje">Estado</div>
<div class="card">
    <div class="card-header">
        <a name="" id="" class="btn btn-success" href="crear.php" role="button">Agregar descripción de Matriz</a>
    </div>
    <div class="card-body">
        <div class="table-responsive-sm">
            <table class="table" id="tabla_id">
                <thead>
                    <tr>                        
                        <th scope="col" width="5%">Abrev</th>
                        <th scope="col" width="25%">Nombre</th>
                        <th scope="col" width="15%">Gestion</th>
                        <th scope="col" width="5%">Orden</th>                        
                        <th scope="col" width="15%">Opciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $registros->fetch(PDO::FETCH_ASSOC)) {
                        ?>
                        <tr class="">                            
                            <td>
                                <?php echo $row["abrev"]; ?>
                            </td>
                            <td>
                                <?php echo $row["nombre"]; ?>
                            </td>
                            <td>
                                <?php echo $row["gestion"]; ?>
                            </td>
                            <td>
                                <?php echo $row["orden"]; ?>
                            </td>                            
                            <td>
                                <!-- Botón editar -->
                                <a name="" id="" class="btn btn-primary"
                                    href="editar.php?iddescripmat=<?php echo $row["iddescripmat"]; ?>" role="button">Editar</a>
                                <!-- Botón eliminar -->
                                <input name="" id="" class="btn btn-danger" type="button" value="Eliminar"
                                    onclick='eliminar("<?php echo $row["iddescripmat"]; ?>", "<?php echo $row["nombre"]; ?>")'>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer text-muted">
        Descripción: Detalle de matrices que deben publicarse.
    </div>
</div>

<!--Validaciones y funciones JavaScript-->
<script language="javascript">
    // Función para Eliminar registro
    const eliminar = async function (iddescripmat, nombre) {
        // Preparamos el formdata
        var opcion = confirm("¿Esta seguro que desea inactivar la matriz "+nombre+"?");
        if (opcion == true) {
            const formData = new FormData();
            // Enviamos por POST
            formData.append("iddescripmat", iddescripmat);
            const respuestaRaw = await fetch("./eliminar.php", {
                method: "POST",
                body: formData,
            });
            const respuesta = await respuestaRaw.json();
            if (respuesta == 'Eliminado') {
                window.location.reload();
            } else {
                // Sacamos el resultado por consola
                setTimeout(function () {
                    $("#mensaje").html("No puede eliminar " + nombre + ", esta siendo utilizada en otro registro.");
                    $(".mensaje").fadeIn(1000);
                }, 0);
                setTimeout(function () {
                    $(".mensaje").fadeOut(1000);
                }, 5000);
            }
        }
    };
</script>
<?php
include_once (TEMPLATE_PATH."footer.php");
?>