<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
// Definicion de variables
$resultado = '';
// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    $gestion = (isset($_POST['txtGestion']) ? $_POST['txtGestion'] : $resultado .= 'No se ingresa Gestión');
    // Comparo que no sea registro duplicado    
    try {
        $select_stmt = $db->prepare("SELECT * from gestiones WHERE descripcion=:gestion");
        $select_stmt->bindParam(":gestion", $gestion);
        $select_stmt->execute();
    } catch (PDOException $e) {
        $resultado .= $e->getMessage();
    }
    // Transfiero datos de la consulta
    $gestiones = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
    // Comprueba si adjunto no existe en la base de datos
    if (count($gestiones) == 0) {
        // Inserto datos en tabla
        try {
            $insert_stmt = $db->prepare("INSERT INTO gestiones (idgestion, descripcion, estado) VALUES (NULL, :gestion, 1)");
            //Parametros de inserción
            $insert_stmt->bindParam(":gestion", $gestion);
            // Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Verifica la inserción correcta y carga del archivo
        if ($insert_stmt) {
            $resultado .= "Registro creado exitosamente.";
        }
        // Imprime los resultados del proceso de carga
        echo '<div class="alert alert-success">' . $resultado . '</div>';
    } else {
        $resultado = "ERROR: Registro duplicado.";
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>

<div class="card">
    <div class="card-header">
        <h4>Agregar Gestión</h4>
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label class="form-label" for="txtGestion">Nombre de Gestión</label>
                <input type="text" id="txtGestion" name="txtGestion" class="form-control" required/>
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Agregar Gestión</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<?php
include_once (TEMPLATE_PATH."footer.php");
?>