<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
// Definicion de variables
$resultado = '';
// Variables de POST
$idgestion = $_GET["idgestion"];
$estados = array('0' => 'Inactivo', '1' => 'Activo'); // Array de combo
// Obtengo datos del formulario
try {
    $select_stmt = $db->prepare("SELECT * from gestiones WHERE idgestion=:idgestion");
    $select_stmt->bindParam(":idgestion", $idgestion);
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
// Transfiero datos de la consulta en la variable $datos
$datos = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    $gestion = ((isset($_POST['txtGestion']) && $_POST['txtGestion'] != '') ? $_POST['txtGestion'] : $resultado .= 'No se ingresa nombre de Gestión');
    $estado = ((isset($_POST['txtEstado'])) ? $_POST['txtEstado'] : $resultado .= 'No se selecciona estado de Gestión');
    // Comparo que no sea registro duplicado
    try {
        $select_stmt = $db->prepare("SELECT * from gestiones WHERE descripcion=:gestion AND idgestion<>:idgestion");
        $select_stmt->bindParam(":idgestion", $idgestion);
        $select_stmt->bindParam(":gestion", $gestion);
        $select_stmt->execute();
    } catch (PDOException $e) {
        $resultado .= $e->getMessage();
    }
    // Transfiero datos de la consulta en la variable $datos
    $gestiones = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
    // Comprueba si adjunto no existe en la base de datos
    if (count($gestiones) == 0) {
        // Inserto datos en tabla
        try {
            $insert_stmt = $db->prepare("UPDATE gestiones SET descripcion=:gestion, estado=:estado WHERE idgestion=:idgestion");
            //Parametros de inserción
            $insert_stmt->bindParam(":idgestion", $idgestion);
            $insert_stmt->bindParam(":gestion", $gestion);
            $insert_stmt->bindParam(":estado", $estado);
            // Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $ex->getMessage();
        }
        // Verifica la inserción correcta
        if ($insert_stmt) {
            $resultado .= "Registro actualizado exitosamente.";
        }
        // Devuelve mensaje resultado exitoso
        echo '<div class="alert alert-success">' . $resultado . '</div>';
    } else {
        // Devuelve mensaje resultado erróneo
        $resultado = "ERROR: Registro duplicado.";
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>
<div class="card">
    <div class="card-header">
        Editar Gestión
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label class="form-label" for="txtGestion">Nombre de Gestión</label>
                <input type="text" id="txtGestion" name="txtGestion" class="form-control"
                    value="<?php echo $datos[0]['descripcion']; ?>" required />
            </div>
            <div class="mb-3">
                <label for="txtEstado" class="form-label">Estado</label>
                <select class="form-select form-select-lg" name="txtEstado" id="txtEstado">
                    <?php
                    for ($i = 0; $i < count($estados); $i++) {
                        if ($datos[0]['estado'] == $i) {
                            echo '<option value="' . $i . '" selected>' . $estados[$i] . '</option>';
                        } else {
                            echo '<option value="' . $i . '">' . $estados[$i] . '</option>';
                        }
                    }
                    ?>
                </select>
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Guardar</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<?php
include_once (TEMPLATE_PATH."footer.php");
?>