<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
// Definicion de variables
$resultado = '';
$lista_privilegios = array('0' => 'Operador', '1' => 'Responsable', '2' => 'Supervisor', '3' => 'Administrador');
$lista_estados = array('0' => 'Inactivo', '1' => 'Activo'); // Array de combo
// Variables de GET
$idusuario = $_GET['idusuario'];
// Obtengo datos de formulario
try {
    // Obtengo datos de usuario
    $select_stmt = $db->prepare("SELECT g.idgestion, u.idusuario, u.nombre, g.descripcion AS gestion, u.usuario, u.estado, u.privilegios, 
        u.correo, u.clave FROM usuarios u INNER JOIN gestiones g ON u.idgestion=g.idgestion LEFT JOIN miembros_comision mc 
        ON u.idusuario=mc.idusuario WHERE u.idusuario=:idusuario ORDER BY u.idusuario ASC");
    $select_stmt->bindParam(":idusuario", $idusuario);
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
// Transfiero datos de la consulta
$datos = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
// Obtengo lista de gestiones
try {
    $select_stmt = $db->prepare("SELECT idgestion, descripcion from gestiones");
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
// Transfiero datos de la consulta
$gestiones = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    $gestion = (isset($_POST['txtGestion']) ? $_POST['txtGestion'] : $resultado .= 'No se ingresa Gestión');
    $nombre = (isset($_POST['txtNombre']) ? $_POST['txtNombre'] : $resultado .= 'No se ingresa Nombre');
    $usuario = (isset($_POST['txtUsuario']) ? $_POST['txtUsuario'] : $resultado .= 'No se ingresa Usuario');
    $clave = (isset($_POST['txtClave']) ? trim($_POST['txtClave']) : false);
    $correo = (isset($_POST['txtCorreo']) ? trim($_POST['txtCorreo']) : $resultado .= 'No se ingresa Correo');
    $privilegios = (isset($_POST['txtPrivilegios']) ? $_POST['txtPrivilegios'] : $resultado .= 'No se ingresa Privilegios');
    $estado = (isset($_POST['txtEstado']) ? $_POST['txtEstado'] : $resultado .= 'No se ingresa Estado');
    // Comparo que no sea registro duplicado    
    try {
        $select_stmt = $db->prepare("SELECT * FROM usuarios WHERE idgestion=:gestion AND nombre=:nombre AND usuario=:usuario AND idusuario<>:idusuario");
        $select_stmt->bindParam(":gestion", $gestion);
        $select_stmt->bindParam(":nombre", $nombre);
        $select_stmt->bindParam(":usuario", $usuario);
        $select_stmt->bindParam(":idusuario", $idusuario);
        $select_stmt->execute();
    } catch (PDOException $e) {
        $resultado .= $e->getMessage();
    }
    // Transfiero datos de la consulta
    $usuarios = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
    // Comprueba si adjunto no existe en la base de datos
    if (count($usuarios) == 0) {
        if ($clave == false) {
            // Actualizo datos en tabla
            try {
                $update_stmt = $db->prepare("UPDATE usuarios SET idgestion=:idgestion, nombre=:nombre, usuario=:usuario, 
                    privilegios=:privilegios, correo=:correo, estado=:estado WHERE idusuario=:idusuario");
                //Parametros de inserción
                $update_stmt->bindParam(":idgestion", $gestion);
                $update_stmt->bindParam(":nombre", $nombre);
                $update_stmt->bindParam(":usuario", $usuario);
                $update_stmt->bindParam(":privilegios", $privilegios);
                $update_stmt->bindParam(":correo", $correo);
                $update_stmt->bindParam(":estado", $estado);
                $update_stmt->bindParam(":idusuario", $idusuario);
                // Ejecución de la consulta
                $update_stmt->execute();
            } catch (Exception $ex) {
                $resultado .= $ex->getMessage();
            }
        } else {
            // Actualizo datos en tabla
            try {
                $update_stmt = $db->prepare("UPDATE usuarios SET idgestion=:idgestion, nombre=:nombre, usuario=:usuario, 
                    clave=SHA1(:clave), privilegios=:privilegios, correo=:correo, estado=:estado WHERE idusuario=:idusuario");
                //Parametros de inserción
                $update_stmt->bindParam(":idgestion", $gestion);
                $update_stmt->bindParam(":nombre", $nombre);
                $update_stmt->bindParam(":usuario", $usuario);
                $update_stmt->bindParam(":clave", $clave);
                $update_stmt->bindParam(":privilegios", $privilegios);
                $update_stmt->bindParam(":correo", $correo);
                $update_stmt->bindParam(":estado", $estado);
                $update_stmt->bindParam(":idusuario", $idusuario);
                // Ejecución de la consulta
                $update_stmt->execute();
            } catch (Exception $ex) {
                $resultado .= $ex->getMessage();
            }
        }
        // Verifica la inserción correcta y carga del archivo
        if ($resultado == '') {
            $resultado .= "Registro creado exitosamente.";
            // Imprime los resultados del proceso de carga
            echo '<div class="alert alert-success">' . $resultado . '</div>';
        } else {
            $resultado .= "Error al insertar el registro.";
            // Imprime los resultados del proceso de carga
            echo '<div class="alert alert-danger">' . $resultado . '</div>';
        }
    } else {
        $resultado = "ERROR: Registro duplicado.";
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>
<div class="card">
    <div class="card-header">
        <h4>Editar usuario</h4>
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="txtGestion" class="form-label">Gestión</label>
                <select class="form-select form-select-lg" name="txtGestion" id="txtGestion" required>
                    <?php
                    foreach ($gestiones as $g) {
                        if ($g['idgestion'] == $datos[0]['idgestion']) {
                            echo '<option value="' . $g['idgestion'] . '" selected>' . $g['descripcion'] . '</option>';
                        } else {
                            echo '<option value="' . $g['idgestion'] . '">' . $g['descripcion'] . '</option>';
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtNombre">Nombre</label>
                <input type="text" id="txtNombre" name="txtNombre" class="form-control"
                    placeholder="Nombre y apellido del usuario" value="<?php echo $datos[0]['nombre']; ?>" required />
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtUsuario">Usuario</label>
                <input type="text" id="txtUsuario" name="txtUsuario" class="form-control"
                    placeholder="Usuario, mínimo 4 caracteres" minlength="4" value="<?php echo $datos[0]['usuario']; ?>"
                    required />
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtClave">Clave</label>
                <input type="password" id="txtClave" name="txtClave" class="form-control"
                    placeholder="Clave mínimo 3 caracteres" minlength="3" />
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtCorreo">Correo</label>
                <input type="email" id="txtCorreo" name="txtCorreo" class="form-control"
                    placeholder="Correo electrónico" required value="<?php echo $datos[0]['correo']; ?>" />
            </div>
            <div class="mb-3">
                <label for="txtPrivilegios" class="form-label">Privilegios</label>
                <select class="form-select form-select-lg" name="txtPrivilegios" id="txtPrivilegios">
                    <?php
                    for ($i = 0; $i < count($lista_privilegios); $i++) {
                        if ($datos[0]['privilegios'] == $i) {
                            echo '<option value="' . $i . '" selected>' . $lista_privilegios[$i] . '</option>';
                        } else {
                            echo '<option value="' . $i . '">' . $lista_privilegios[$i] . '</option>';
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="txtEstado" class="form-label">Estado</label>
                <select class="form-select form-select-lg" name="txtEstado" id="txtEstado">
                    <?php
                    for ($i = 0; $i < count($lista_estados); $i++) {
                        if ($datos[0]['estado'] == $i) {
                            echo '<option value="' . $i . '" selected>' . $lista_estados[$i] . '</option>';
                        } else {
                            echo '<option value="' . $i . '">' . $lista_estados[$i] . '</option>';
                        }
                    }
                    ?>
                </select>
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Actualizar usuario</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<?php
include_once (TEMPLATE_PATH."footer.php");
?>