<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'].'/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
// Obtengo variables de SESSION
$idgestion = $_SESSION["idgestion"];
$idmiembro = $_SESSION["idmiembro"];
$idusuario = $_SESSION["idusuario"];
$sentencia = "SELECT ROW_NUMBER() OVER (ORDER BY dm.orden ASC) AS 'orden', m.idmatriz, CONCAT(abrev,') ',dm.descripcion) AS matriz, m.idmatriz, ar.idarchivo, u.nombre AS nombreusuario,
    fechamodificacion, ar.nombrearchivo, ar.anio, ar.mes, ar.fechahoracarga AS fechacarga, m.estado, g.descripcion AS nombregestion
    FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat
    INNER JOIN usuarios u ON m.idusuario=u.idusuario
    INNER JOIN gestiones g ON dm.idgestion=g.idgestion
    INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo    
    WHERE dm.estado=1 AND m.idmatriz NOT IN (SELECT idmatriz FROM revisiones r INNER JOIN miembros_comision mc ON 
    r.idmiembro_comision=mc.idmiembro_comision WHERE mc.idusuario=:idusuario) AND m.estado <> '2' 
    AND dm.orden <> 0 
    AND m.fechamodificacion > (SELECT f_inicio_gestion FROM miembros_comision WHERE aprobador=1 AND estado=1 AND idusuario=:idusuario)";
$registros = $db->prepare($sentencia);
$registros->bindParam(":idusuario", $idusuario);
$registros->execute();
?>

<style>
    textarea {
        resize: none;
    }

    #count_message {
        background-color: smoke;
        margin-top: -20px;
        margin-right: 5px;
    }
</style>

<div class="card">
    <div class="card-header">
        <h4>Revisión de matrices</h4>
    </div>
    <div class="card-body">
        <div class="table-responsive-sm">
            <table class="table" id="tabla_id">
                <thead>
                    <tr>
                        <th scope="col" width="2%">Ord</th>
                        <th scope="col" width="20%">Matriz</th>
                        <th scope="col" width="2%">Año</th>
                        <th scope="col" width="2%">Mes</th>
                        <th scope="col" width="8%">Poseedora de la Información</th>
                        <th scope="col" width="8%">Emisor</th>
                        <th scope="col" width="20%">Opciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $registros->fetch(PDO::FETCH_ASSOC)) {
                        ?>
                        <tr class="">
                            <td scope="row">
                                <?php echo $row["orden"]; ?>
                            </td>
                            <td>
                                <?php echo $row["matriz"]; ?>
                            </td>
                            <td>
                                <?php echo $row["anio"]; ?>
                            </td>
                            <td>
                                <?php echo GetnombreMes($row["mes"]); ?>
                            </td>
                            <td>
                                <?php echo $row["nombregestion"]; ?>
                            </td>
                            <td>
                                <?php echo $row["nombreusuario"]; ?>
                            </td>
                            <td>
                                <!-- Botón aprobar -->
                                <button class="btn btn-success" type="button"
                                    onclick='aprobar("<?php echo $idmiembro; ?>", "<?php echo $row["idmatriz"]; ?>")'>Aprobar <i class="fa-solid fa-check"></i></button>
                                <!-- Botón observar -->
                                <button type="button" class="btn btn-danger" data-bs-toggle="modal"
                                    data-bs-target="#modalObservacion" data-bs-idmatriz="<?php echo $row["idmatriz"]; ?>"
                                    data-bs-matriz="<?php echo $row["matriz"]; ?>"
                                    data-bs-idmiembro="<?php echo $idmiembro; ?>">Observar <i class="fa-solid fa-close"></i></button>
                                <!-- Botón ver -->
                                <button class="btn btn-secondary" type="button"
                                    onclick='ver_pdf("<?php echo $row["nombrearchivo"]; ?>")'><i class="fa-solid fa-magnifying-glass"></i></button>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class=" card-footer text-muted">
        Descripción: Aprobación por parte de los miembros de la comisión para la publicación de
        matrices.
    </div>
</div>

<!-- Modal de vista de observaciones -->
<div class="modal fade" id="modalObservacion" tabindex="-1" aria-labelledby="modalObservacionLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalObservacionLabel">Registrar observación</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="post">
                    <div class="mb-3">
                        <input type="hidden" id="accion" name="accion" value="observar">
                        <input type="hidden" id="idmiembro" name="idmiembro">
                        <input type="hidden" id="idmatriz" name="idmatriz">
                        <label for="txtObservacion" class="col-form-label">Observación:</label>
                        <textarea class="form-control" id="txtObservacion" name="txtObservacion" rows="5"
                            placeholder="Escriba aquí su observación..." maxlength="240"></textarea>
                        <span class="pull-right label label-default" id="count_message"></span>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <!-- Botón cerrar -->
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <!-- Botón aprobar -->
                <input name="btnRegistrarObs" id="btnRegistrarObs" class="btn btn-danger" type="button"
                    value="Registrar Observación">
            </div>
        </div>
    </div>
</div>

<!-- Mostrar modal modalObservacion -->
<script>
    var modalObservacion = document.getElementById('modalObservacion')
    modalObservacion.addEventListener('show.bs.modal', function (event) {
        // Button that triggered the modal
        var button = event.relatedTarget;
        // Extract info from data-bs-* attributes
        var matriz = button.getAttribute('data-bs-matriz');
        var idmatriz = button.getAttribute('data-bs-idmatriz');
        var idmiembro = button.getAttribute('data-bs-idmiembro');
        // Update the modal's content.
        var modalTitle = modalObservacion.querySelector('.modal-title');
        var modal_idmatriz = modalObservacion.querySelector('.modal-body #idmatriz');
        var modal_idmiembro = modalObservacion.querySelector('.modal-body #idmiembro');
        modalTitle.textContent = 'Registrar observación en matriz: ' + '"' + matriz + '"';
        modal_idmatriz.value = idmatriz;
        modal_idmiembro.value = idmiembro;
    });

    // Borra el campo observaciones luego de cerrar
    modalObservacion.addEventListener('hidden.bs.modal', function (event) {
        document.getElementById('txtObservacion').value = '';
    });

    // Cuenta los caracteres digitados
    var text_max = 240;
    $('#count_message').html('0 / ' + text_max + ' caracteres.');
    $('#txtObservacion').keyup(function () {
        var text_length = $('#txtObservacion').val().length;
        var text_remaining = text_max - text_length;
        $('#count_message').html(text_length + ' / ' + text_max);
    });

</script>

<!--Validaciones y funciones JavaScript-->
<script language="javascript">

    // Objetos del DOM
    const
        $btnRegistrarObs = document.querySelector("#btnRegistrarObs");

    // Validacion de boton Observar
    $btnRegistrarObs.addEventListener("click", async () => {
        // Preparamos el formdata
        const formData = new FormData();
        // Obtenemos fecha de envio
        var accion = document.getElementById('accion').value;
        var idmatriz = document.getElementById('idmatriz').value;
        var idmiembro = document.getElementById('idmiembro').value;
        var obs = document.getElementById('txtObservacion').value;

        if (obs.length > 9) {
            // Defino parametros de POST
            formData.append("accion", accion);
            formData.append("idmatriz", idmatriz);
            formData.append("idmiembro", idmiembro);
            formData.append("obs", obs);
            // Envio el POST
            const respuestaRaw = await fetch("./revisar.php", {
                method: "POST",
                body: formData,
            });
            const respuesta = await respuestaRaw.json();
            // Sacamos el resultado por consola
            console.log({ respuesta });
            // Limpiamos el campo de archivos
            window.location.reload();
        } else {
            alert("El texto de la observación debe contener 10 caracteres como mínimo.");
            document.getElementById('txtObservacion').focus();
        }
    });

    // Función para aprobar matriz
    const aprobar = async function (idmiembro, idmatriz) {
        const accion = 'aprobar';
        // Preparamos el formdata
        var opcion = confirm("¿Esta seguro que desea aprobar ésta matriz?");
        if (opcion == true) {
            const formData = new FormData();
            // Enviamos por POST
            formData.append("idmiembro", idmiembro);
            formData.append("idmatriz", idmatriz);
            formData.append("accion", accion);
            const respuestaRaw = await fetch("./revisar.php", {
                method: "POST",
                body: formData,
            });
            const respuesta = await respuestaRaw.json();
            // Sacamos el resultado por consola
            console.log({ respuesta });
            window.location.reload();
        }
    };

    // Función para mostrar/descargar el archivo
    const ver_pdf = async function (nombrearchivo) {
        var protocolo = window.location.protocol + '//';
        var host = window.location.hostname;
        var path = window.location.pathname;
        var path_parts = path.split('/');
        var repositorio = '/' + path_parts[1] + '/repositorio/';
        var url = protocolo + host + repositorio + nombrearchivo;
        window.open(url, "_blank");
    };

</script>
<?php
include(TEMPLATE_PATH."footer.php");
?>