<?php
// Direccionamiento dinámico (Obligatorio)
include_once($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once(CONF_PATH . "db.php");
include_once(INCLUDES_PATH . "funciones.php");

// Definicion variables
$resultado = '';
// Variables de POST
$accion = $_POST['accion'];
$idmiembro = $_POST['idmiembro'];
$idmatriz = $_POST['idmatriz'];
if ($accion == 'aprobar') {
    // Insertar revision aprobada
    try {
        $insert_stmt = $db->prepare("INSERT INTO revisiones (idrevision, idmiembro_comision, idmatriz, fechahora, observacion, resultado) 
            VALUES(NULL, :idmiembro, :idmatriz, now(), NULL, 0)");
        //Parametros de inserción
        $insert_stmt->bindParam(":idmiembro", $idmiembro);
        $insert_stmt->bindParam(":idmatriz", $idmatriz);
        //Ejecución de la consulta
        $insert_stmt->execute();
        if ($insert_stmt) {
            // Consulta de idmatriz insertada para envio de notificacion
            try {
                $select_stmt = $db->prepare("SELECT estado FROM matrices WHERE idmatriz=:idmatriz");
                $select_stmt->bindParam(":idmatriz", $idmatriz);
                //Ejecución de la consulta
                $select_stmt->execute();
            } catch (Exception $ex) {
                $resultado .= $ex->getMessage();
            }
            $estado = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
            if ($estado[0]['estado'] == 3) {
                //-------OJO COMENTAR SOLO PARA CARGAR MATRICES ANTERIORES
                EnviarNotificacion($idmatriz, 1); // Matriz aprobada, envío de notificacion a miembros Unidad poseedora de informacion
            }
        }
    } catch (Exception $ex) {
        $resultado .= $ex->getMessage();
    }
} else if ($accion == 'observar') {
    $observacion = $_POST['obs'];
    // Insertar revision observada
    try {
        $insert_stmt = $db->prepare("INSERT INTO revisiones (idrevision, idmiembro_comision, idmatriz, fechahora, observacion, resultado) 
            VALUES(NULL, :idmiembro, :idmatriz, now(), :observacion, 1)");
        //Parametros de inserción
        $insert_stmt->bindParam(":idmiembro", $idmiembro);
        $insert_stmt->bindParam(":idmatriz", $idmatriz);
        $insert_stmt->bindParam(":observacion", $observacion);
        //Ejecución de la consulta
        $insert_stmt->execute();
        // Envío de notificacion a correo miembros Unidad poseedora de la informacion
        if ($insert_stmt) {
            //-------OJO COMENTAR SOLO PARA CARGAR MATRICES ANTERIORES
            EnviarNotificacion($idmatriz, 2); // Matriz observada, envío de notificacion a miembros Unidad poseedora de informacion
        }
    } catch (Exception $ex) {
        $resultado .= $ex->getMessage();
    }
}
// Respuesta de JSON
echo json_encode($resultado);
?>