<?php
// Direccionamiento dinámico (Obligatorio)
include_once($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
// Incluimos config de db y parámetros globales del sistema
require_once(CONF_PATH . "db.php");
// Incluimos las funciones del proyecto
require_once(INCLUDES_PATH . "funciones.php");
// Verificamos que se establezca una sesion
if (session_status() == PHP_SESSION_NONE) {
  session_start();
}
// Verifica si esta logueado
if (!isset($_SESSION["usuario"])) {
  die(header("refresh:0;" . $url_base . "secciones/main/sinpriv.php"));
} else {
  $nom_usuario = $_SESSION["nombre"];
  $privilegios = $_SESSION["privilegios"];
  $aprobador = $_SESSION["aprobador"];
  $estado_aprobador = $_SESSION["estado_aprobador"];
  $estado_usuario = $_SESSION["estado_usuario"];
  $gestion = $_SESSION["gestion"];
}
?>
<!doctype html>
<html lang="en">

<head>
  <title>SisLotaip RPMCC</title>
  <!-- Required meta tags -->
  <meta charset="utf-8">

  <!-- Iconos Font Awsome v5 FREE - Codigo generado gcarranco@hotmail.com -->
  <script src="https://kit.fontawesome.com/472f927bf2.js" crossorigin="anonymous"></script>

  <!-- Bootstrap CSS v5.3.0 min-->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet"
    integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">

  <!-- Jquery v3.6.4 -->
  <script src="https://code.jquery.com/jquery-3.6.4.min.js"
    integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>

  <!-- Bootstrap CSS v5.3.0 bundle-->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"
    integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe"
    crossorigin="anonymous"></script>

  <!-- Datatables v1.13.4 -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.css" />
  <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>

  <!-- Ion icons v5 -->
  <link href="https://unpkg.com/ionicons@4.5.10-0/dist/css/ionicons.min.css" rel="stylesheet">
  
  <!-- Datetimepicker -->
  <script src="https://unpkg.com/gijgo@1.9.14/js/gijgo.min.js" type="text/javascript"></script>
  <link href="https://unpkg.com/gijgo@1.9.14/css/gijgo.min.css" rel="stylesheet" type="text/css" />
  <script src="https://unpkg.com/gijgo@1.9.14/js/messages/messages.es-es.js" type="text/javascript"></script>
  
</head>

<body>
  <header>
    <nav class="navbar navbar-expand-lg bg-body-tertiary">
      <div class="container-fluid">
        <a class="navbar-brand" href="#">SISLOTAIP</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
          aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
          <ul class="navbar-nav me-auto mb-2 mb-lg-0">
            <li class="nav-item">
              <a class="nav-link active" aria-current="page"
                href="<?php echo $url_base; ?>secciones/main/index.php">Inicio</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" aria-current="page" href="<?php echo $url_base; ?>secciones/formatos/index.php"
                <?php echo ($privilegios < 2) ? '' : 'hidden' ?>>Formatos</a>
            </li>
            <li class="nav-item">
              <a class="nav-link active" aria-current="page" href="<?php echo $url_base; ?>secciones/revision/index.php"
                <?php echo ($privilegios > 0 && $aprobador == 1 && $estado_aprobador == 1) ? '' : 'hidden' ?>>Revisión</a>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"
                <?php echo ($privilegios < 2) ? '' : 'hidden' ?>> Adjuntos
              </a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="<?php echo $url_base; ?>secciones/adjuntos/index.php">Listado
                    adjuntos</a></li>
                <li><a class="dropdown-item" href="<?php echo $url_base; ?>secciones/adjuntos/crear.php">Agregar
                    adjunto</a></li>
              </ul>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"
                <?php echo ($privilegios > 0 && $privilegios < 2) ? '' : 'hidden' ?>>
                Matrices
              </a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="<?php echo $url_base; ?>secciones/matrices/index.php">Listado
                    matrices</a></li>
                <li><a class="dropdown-item" href="<?php echo $url_base; ?>secciones/matrices/crear.php">Agregar
                    matriz</a></li>
                <li><a class="dropdown-item" href="<?php echo $url_base; ?>secciones/matrices/idx_descargar.php" <?php echo ($gestion == 'Responsable LOTAIP') ? '' : 'hidden' ?>>Descargar por mes</a></li>
              </ul>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"
                <?php echo ($privilegios > 1) ? '' : 'hidden' ?>>
                Administración
              </a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item"
                    href="<?php echo $url_base; ?>secciones/administracion/adjuntos/index.php">Adjuntos</a></li>
                <li><a class="dropdown-item"
                    href="<?php echo $url_base; ?>secciones/administracion/matrices/index.php">Matrices</a></li>
                <div class="dropdown-divider"></div>
                <li><a class="dropdown-item"
                    href="<?php echo $url_base; ?>secciones/administracion/formatos/index.php">Formatos</a></li>
              </ul>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"
                <?php echo ($privilegios > 2) ? '' : 'hidden' ?>>
                Parámetros
              </a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item"
                    href="<?php echo $url_base; ?>secciones/parametros/gestiones/index.php">Gestiones</a></li>
                <li><a class="dropdown-item"
                    href="<?php echo $url_base; ?>secciones/parametros/descripmatrices/index.php">Descrip. Matrices</a></li>
                <li><a class="dropdown-item"
                    href="<?php echo $url_base; ?>secciones/parametros/miembros/index.php">Miembros comisión</a></li>
                <li><a class="dropdown-item"
                    href="<?php echo $url_base; ?>secciones/parametros/usuarios/index.php">Usuarios</a></li>
              </ul>
            </li>
          </ul>
          <div class="dropdown">
            <button class="btn btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown"
              aria-expanded="false">
              Bienvenido(a),
              <?php echo $nom_usuario; ?>
            </button>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="<?php echo $url_base; ?>secciones/main/cambiarclave.php">Cambiar
                  clave</a>
              </li>
              <li><a class="dropdown-item" href="<?php echo $url_base; ?>secciones/main/logout.php">Cerrar sesión</a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </nav>
  </header>
  <main class='container'>
    <br>