<?php
// Direccionamiento dinámico (Obligatorio)
include_once($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once(INCLUDES_PATH . 'funciones.php');
if (isset($_POST['tipo_csv']) && isset($_POST['matriz_zip'])) {
    // Obtengo variables de POST
    $tipo_csv = $_POST['tipo_csv'];
    $matriz_zip = $_POST['matriz_zip'];
    // Identifico el archivo zip de origen
    $archivo_zip = REPO_PATH . $matriz_zip;
    // Defino nombres de directorios temporales
    $partes_nombre = explode(".", $matriz_zip);
    $dir_destino = TEMP_PATH . $partes_nombre[0];
    // Creo directorio temporal de matriz
    mkdir($dir_destino);
    // Descomprimo los archivos de la matriz en directorio temporal
    Extraer($archivo_zip, $dir_destino);
    // Identifico archivo csv a descargar
    $csv = BuscarCSV($dir_destino, $tipo_csv);
    // Forzar descarga de archivo csv
    $csv_descarga = $dir_destino . '/' . $csv;
    if (file_exists($csv_descarga)) {
        header('Content-Description: File Transfer');
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename=' . basename($csv_descarga));
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($csv_descarga));
        ob_clean();
        flush();
        readfile($csv_descarga);
    } else {
        $resultado = 'CSV no disponible en el archivo comprimido de la matriz, consulte con la UPGE del RPMC.';
        // Reporta resultado
        echo json_encode($resultado);
    }
    // Elimino los directorios y archivos temporales del directorio temp/
    EliminarTodo($dir_destino);
} else {
    $resultado = 'Acceso denegado.';
    // Reporta resultado
    echo json_encode($resultado);
}
