<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
// PHPMailer
require_once (LIB_PATH . 'PHPMailer6.3/src/Exception.php');
require_once (LIB_PATH . 'PHPMailer6.3/src/PHPMailer.php');
require_once (LIB_PATH . 'PHPMailer6.3/src/SMTP.php');
use PHPMailer\PHPMailer\PHPMailer;

function GetMatricesPendientes($anio_inicio, $mes_ini, $idgestion)
{
    include (CONF_PATH . 'db.php');
    // Definicion de variables
    $anio_actual = date('Y');
    $mes_actual = date('m');
    $cont_mes_ini = 0;
    $cont_mes_fin = 0;
    $matrices_pendientes = array();
    // Obtengo listado matrices por gestion
    try {
        $select_stmt = $db->prepare("SELECT abrev, descripcion FROM descrip_matriz WHERE idgestion=:idgestion AND estado=1 ORDER BY orden");
        $select_stmt->bindParam(":idgestion", $idgestion);
        $select_stmt->execute();
    } catch (PDOException $e) {
        echo $e->getMessage();
    }
    $matrices_por_gestion = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
    // Obtengo matrices cumplidas
    try {
        $select_stmt = $db->prepare("SELECT abrev, dm.descripcion, ar.anio, ar.mes
        FROM matrices m INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat    
        WHERE m.estado<>2 AND dm.idgestion=:idgestion");
        $select_stmt->bindParam(":idgestion", $idgestion);
        $select_stmt->execute();
    } catch (PDOException $e) {
        echo $e->getMessage();
    }
    $matrices_cumplidas = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
    // Obtengo listado matrices pendientes desde fecha de produccion hasta fecha actual
    for ($i = $anio_inicio; $i <= $anio_actual; $i++) {
        // Cuenta meses desde el mes de inicio de producción o desde enero hasta la fecha actual
        if ($i == $anio_actual) {
            if ($cont_mes_fin == 12) {
                $cont_mes_ini = 1;
                $cont_mes_fin = $mes_actual - 1;
            } else {
                $cont_mes_ini = $mes_ini;
                $cont_mes_fin = $mes_actual - 1;
            }
        } elseif ($cont_mes_fin == 0) {
            $cont_mes_ini = $mes_ini;
            $cont_mes_fin = 12;
        } else {
            $cont_mes_ini = 1;
            $cont_mes_fin = 12;
        }
        // Verificamos matrices cumplidas en el rango de meses
        for ($j = $cont_mes_ini; $j <= $cont_mes_fin; $j++) {
            foreach ($matrices_por_gestion as $mpg) {
                $matriz_cumplida = false; // bandera identifica matriz cumplida                
                foreach ($matrices_cumplidas as $mc) {
                    if ($mpg['abrev'] == $mc['abrev']) {
                        if ($mc['anio'] == $i && $mc['mes'] == $j) {
                            $matriz_cumplida = true;
                        }
                    }
                }
                // Controlo el cambio de año
                $anio = $i;
                $mes = $j;
                if ($mes == 0) {
                    $mes = 12;
                    $anio = $anio - 1;
                }
                // Reportamos las matrices pendientes
                if ($matriz_cumplida == false) {
                    $registro = [
                        'abrev' => $mpg['abrev'],
                        'descripcion' => $mpg['descripcion'],
                        'anio' => $anio,
                        'mes' => $mes
                    ];
                    array_push($matrices_pendientes, $registro);
                }
            }
        }
    }
    return $matrices_pendientes;
}

function ReportePendientesCumplimiento($matrices_pendientes)
{
    $result = array();
    $registro = array();
    foreach ($matrices_pendientes as $mp) {
        if ($mp['mes'] == 1) {
            $registro = [
                'abrev' => $mp['abrev'],
                'descripcion' => $mp['descripcion'],
                'anio' => $mp['anio'] - 1,
                'mes' => 12
            ];
        } else {
            $registro = [
                'abrev' => $mp['abrev'],
                'descripcion' => $mp['descripcion'],
                'anio' => $mp['anio'],
                'mes' => $mp['mes'] - 1
            ];
        }
        array_push($result, $registro);
    }
    return $result;
}

// Devuelve el mes de acuerdo a su número
function GetNombreMes($numero)
{
    $meses = array(
        '1' => 'Enero',
        '2' => 'Febrero',
        '3' => 'Marzo',
        '4' => 'Abril',
        '5' => 'Mayo',
        '6' => 'Junio',
        '7' => 'Julio',
        '8' => 'Agosto',
        '9' => 'Septiembre',
        '10' => 'Octubre',
        '11' => 'Noviembre',
        '12' => 'Diciembre'
    );
    return $meses[abs($numero)];
}

function GetRol($privilegios)
{
    $rol = array(
        '0' => 'Operador',
        '1' => 'Responsable',
        '2' => 'Administrador',
        '3' => 'Superadministrador'
    );
    return $rol[abs($privilegios)];
}

function GetEstadoMatriz($estado, $idmatriz)
{
    include (CONF_PATH . 'db.php');
    // Definicion de variables
    $observaciones = "<p><b>La matriz tiene las siguientes observaciones:</b></p>";
    // Obtengo las observaciones
    try {
        $select_stmt = $db->prepare("SELECT observacion FROM revisiones WHERE idmatriz=:idmatriz");
        $select_stmt->bindParam(":idmatriz", $idmatriz);
        $select_stmt->execute();
    } catch (PDOException $e) {
        $observaciones = $e->getMessage();
    }
    $obs = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
    $cont = 0;
    foreach ($obs as $o) {
        $cont++;
        $observaciones .= "<ul class='list-group'><li class='list-group-item'>" . $cont . ') ' . $o['observacion'] . "</li></ul>";
    }
    $observaciones .= "<br><mark><b>Debe eliminar la matriz actual para poder cargar la matriz corregida.<b></mark>";

    switch ($estado) {
        case 0: {
            $res = '<button type="button" class="btn btn-outline-secondary btn-sm" data-bs-toggle="modal"
            data-bs-target="#modalObservaciones" data-bs-obs="La matriz se encuentra en estado Borrador, puede modificarla o eliminarla." >Borrador</button>';
        }
            break;
        case 1: {
            $res = '<button type="button" class="btn btn-outline-warning btn-sm" data-bs-toggle="modal"
            data-bs-target="#modalObservaciones" data-bs-obs="La matriz está siendo revisada por los miembros de la Comisión, NO puede modificarla o eliminarla.">Revisión</button>';
        }
            break;
        case 2: {
            $res = '<button type="button" class="btn btn-outline-danger btn-sm" data-bs-toggle="modal"
            data-bs-target="#modalObservaciones" data-bs-obs="' . $observaciones . '">Observado</button>';
        }
            break;
        case 3: {
            $res = '<button type="button" class="btn btn-outline-success btn-sm" data-bs-toggle="modal"
            data-bs-target="#modalObservaciones" data-bs-obs="La matriz se encuentra en estado Publicado, NO puede modificarla o eliminarla.">Publicado</button>';
        }
            break;
    }
    return $res;
}

function GetEstadoAdjunto($estado, $id)
{
    switch ($estado) {
        case 0: {
            $res = '<button type="button" class="btn btn-outline-warning btn-sm" value="' . $estado . '">Borrador</button>';
        }
            break;
        case 1: {
            $res = '<button type="button" class="btn btn-outline-success btn-sm" value="' . $estado . '">Enlazado</button>';
        }
            break;
    }
    return $res;
}

// Verificar estructura de correo
function ComprobarEmail($email)
{
    return (boolean) filter_var($email, FILTER_VALIDATE_EMAIL);
}

// Set datos de conexión de correo de envio
function ConexionCorreo()
{
    date_default_timezone_set("America/Guayaquil");
    $mail = new PHPMailer(true);
    try {
        //Server settings [rpcayambe]
        $mail->SMTPDebug = 0; // Activar debug
        $mail->isSMTP();
        $mail->SMTPSecure = "ssl";
        $mail->Host = 'webserv.rpcayambe.gob.ec';
        $mail->SMTPAuth = true;
        $mail->Port = 465;
        $mail->Username = 'envio@mailing.rpcayambe.gob.ec';
        $mail->Password = 'Rpm.0101.Cay';
        $mail->CharSet = 'UTF-8';
        $mail->setFrom('info@rpcayambe.gob.ec', 'Registro de la Propiedad y Mercantil del Canton Cayambe');
        $mail->IsHTML(true);
    } catch (Exception $e) {
        echo "Error en definicion de parametros PHPMailer.";
    }
    return $mail;
}

function BuscarClaveArray($array, $campo, $valor)
{
    foreach ($array as $key => $elemento) {
        if ($elemento[$campo] === $valor) {
            return $key;
        }
    }
    return false;
}

function EnviarNotificacion($idmatriz, $op, $debug)
{
    include (CONF_PATH . 'db.php');
    if ($debug == false) {
        // Obtengo las observaciones
        try {
            $select_stmt = $db->prepare("SELECT g.idgestion, g.descripcion as gestion, concat(dm.abrev, ') ', dm.descripcion) as matriz, m.fechamodificacion, a.anio, a.mes, r.observacion 
            FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat INNER JOIN gestiones g ON dm.idgestion=g.idgestion INNER JOIN archivos a 
            ON m.idarchivo=a.idarchivo LEFT JOIN revisiones r ON m.idmatriz=r.idmatriz
            WHERE m.idmatriz=:idmatriz AND dm.estado=1");
            $select_stmt->bindParam(":idmatriz", $idmatriz);
            $select_stmt->execute();
        } catch (PDOException $e) {
            echo $e->getMessage();
        }
        // Obtenemos los datos consultados en la variable
        $datos_matriz = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
        // Opciones ($op):
        // 0: Matriz enviada a revisión (Para: Miembros comisión)
        // 1: Matriz publicada (Para: Gestión poseedora de la informacion)
        // 2: Matriz observada (Para: Gestión poseedora de la informacion)        
        $mensaje = '<p>Estimado(a) Usuario(a):</p><br>';
        switch ($op) {
            case 0: {
                $asunto = "SISLOTAIP - Matriz pendiente de revisión";
                $mensaje .= "<p>La matriz <b>" . $datos_matriz[0]['matriz'] . "</b> correspondiente al mes de " . GetNombreMes($datos_matriz[0]['mes']) . " del año " . $datos_matriz[0]['anio'] . ", ha sido cargada al sistema SISLOTAIP por la " . $datos_matriz[0]['gestion'] . " y requiere de su revisión.</p>";
                // Obtengo los destinatarios aprobadores
                try {
                    $select_stmt = $db->prepare("SELECT correo FROM usuarios u INNER JOIN miembros_comision mc ON u.idusuario=mc.idusuario 
                        WHERE u.estado=1 AND mc.aprobador=1 AND mc.estado=1");
                    $select_stmt->execute();
                } catch (PDOException $e) {
                    echo $e->getMessage();
                }
                // Obtenemos los datos consultados en la variable
                $para = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
            }
                break;
            case 1: {
                $asunto = "SISLOTAIP - Matriz publicada";
                $mensaje .= "<p>La matriz <b>" . $datos_matriz[0]['matriz'] . "</b> correspondiente al mes de " . GetNombreMes($datos_matriz[0]['mes']) . " del año " . $datos_matriz[0]['anio'] . ", ha sido aprobada y publicada con éxito.</p>";
                // Obtengo los destinatarios de las Gestiones
                try {
                    $select_stmt = $db->prepare("SELECT correo FROM usuarios WHERE idgestion=:idgestion");
                    $select_stmt->bindParam(":idgestion", $datos_matriz[0]['idgestion']);
                    $select_stmt->execute();
                } catch (PDOException $e) {
                    echo $e->getMessage();
                }
                // Obtenemos los datos consultados en la variable
                $para = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
            }
                break;
            case 2: {
                $asunto = "SISLOTAIP - Matriz observada!";
                $mensaje .= "<p>La matriz <b>" . $datos_matriz[0]['matriz'] . "</b> correspondiente al mes de " . GetNombreMes($datos_matriz[0]['mes']) . " del año " . $datos_matriz[0]['anio'] . ", tiene la siguiente observación:<br></p><p><mark>" . $datos_matriz[0]['observacion'] . "</mark></p>";
                // Obtengo los destinatarios de las Gestiones
                try {
                    $select_stmt = $db->prepare("SELECT correo FROM usuarios WHERE idgestion=:idgestion");
                    $select_stmt->bindParam(":idgestion", $datos_matriz[0]['idgestion']);
                    $select_stmt->execute();
                } catch (PDOException $e) {
                    echo $e->getMessage();
                }
                // Obtenemos los datos consultados en la variable
                $para = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
            }
                break;
        }
        $mensaje .= '<br><p><b>NOTIFICACIONES SISLOTAIP</b></p><br>';
        $mensaje .= '<img src="https://www.rpcayambe.gob.ec/site/images/footer_mail.png" width="790" height="137" />';
        // Instancio los parámetros de envío
        $mail = ConexionCorreo();
        // Envio a cada direccion de correo
        for ($i = 0; $i < count($para); $i++) {
            foreach ($para[$i] as $p) {
                if (ComprobarEmail($p)) {
                    $mail->AddAddress($p); //Para
                    $mail->Subject = $asunto; //Asunto
                    $mail->Body = $mensaje; //Mensaje
                    try {
                        $exito = $mail->Send(); //Enviar
                    } catch (Exception $e) {
                        //echo "Error de PHPMailer: ".$mail->ErrorInfo;
                        $exito = false;
                    }
                } else {
                    $exito = false;
                    //echo "Error de PHPMailer: ".$mail->ErrorInfo;
                }
            }
        }
    } else {
        $exito = true; // Forzar a true en DEBUG
    }
    //Notificamos el estado del envío    
    return $exito;
}

//-----Extraer archivos zip a la raiz de un directorio
function Extraer($ruta_zip, $dest = '.')
{
    $zip = new ZipArchive;
    if ($zip->open($ruta_zip)) {
        for ($i = 0; $i < $zip->numFiles; $i++) {
            $entry = $zip->getNameIndex($i);
            if (substr($entry, -1) == '/')
                continue; // skip directories
            $fp = $zip->getStream($entry);
            $ofp = fopen($dest . '/' . basename($entry), 'w');
            if (!$fp)
                throw new Exception('Unable to extract the file.');
            while (!feof($fp))
                fwrite($ofp, fread($fp, 8192));
            fclose($fp);
            fclose($ofp);
        }
        $zip->close();
    } else {
        return false;
    }
    return $zip;
}

//----Eliminar directorio y archivos de manera recursiva
function EliminarTodo($folderPath)
{
    $files = glob($folderPath . '/*');
    foreach ($files as $file) {
        is_dir($file) ? EliminarTodo($file) : unlink($file);
    }
    // No elimina directorio temp
    if ($folderPath != 'temp/') {
        rmdir($folderPath);
    }
    return;
}

//----Identificar el archivo CSV a descargar
function BuscarCSV($path, $tipo_csv)
{
    $dir = opendir($path);
    $files = array();
    while ($current = readdir($dir)) {
        if ($current != "." && $current != "..") {
            if (is_dir($path . $current)) {
                BuscarCSV($path . $current . '/', $tipo_csv);
            } else {
                $files[] = $current;
            }
        }
    }
    foreach ($files as $f) {
        if (strpos(strtolower($f), strtolower($tipo_csv)) !== FALSE) {
            return $f;
        }
    }
    return 0;
}

// ----Comprimir archivos ZIP
function ComprimirZip($ruta, $nombre_zip, $anio, $mes)
{
    include (CONF_PATH . 'db.php');
    // Definir variables    
    $zip = new ZipArchive();
    // Obtengo archivos de matrices a comprimir
    try {
        $select_stmt = $db->prepare("SELECT nombrearchivo, CONCAT(dm.abrev, '.', dm.descripcion) as descrip_matriz
        FROM archivos a INNER JOIN matrices m ON a.idarchivo=m.idarchivo INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat
        WHERE anio=:anio AND mes=:mes");
        $select_stmt->bindParam(":anio", $anio);
        $select_stmt->bindParam(":mes", $mes);
        $select_stmt->execute();
    } catch (PDOException $e) {
        $e->getMessage();
        return false;
    }
    // Obtenemos los datos consultados en la variable
    $matrices = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
    // Creamos el arhivos zip

    if (count($matrices) > 0) {
        $zip->open($ruta . $nombre_zip, ZipArchive::CREATE);
        foreach ($matrices as $m) {
            $info = new SplFileInfo($m['nombrearchivo']);
            $ext = ($info->getExtension());
            $zip->addFile(REPO_PATH . $m['nombrearchivo'], $m['descrip_matriz'] . '.' . $ext);
        }
        $zip->close();
        return true;
    } else {
        return false;
    }    
}


