<?php
// Direccionamiento dinámico (Obligatorio)
include_once($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once(TEMPLATE_PATH . "header.php");
// Definicion de variables
$url_repositorio = $url_base . 'repositorio/';
// Variables de SESSION
$idgestion = $usuario = $_SESSION["idgestion"];
$nom_usuario = $_SESSION["nombre"];
try {
    $sentencia = "SELECT ROW_NUMBER() OVER (ORDER BY ar.fechahoracarga DESC) AS 'orden', ad.idadjunto, ar.idarchivo, ad.descripcion AS adjunto, ad.fechamodificacion,
        ad.estado, ar.nombrearchivo, anio, mes, fechahoracarga AS fechacarga, u.nombre AS nombreusuario 
        FROM adjuntos ad INNER JOIN archivos ar ON ad.idarchivo=ar.idarchivo INNER JOIN usuarios u on ad.idusuario=u.idusuario WHERE ad.idgestion=:idgestion";
    $registros = $db->prepare($sentencia);
    $registros->bindParam(":idgestion", $idgestion);
    $registros->execute();
} catch (Exception $ex) {
    $resultado .= $ex->getMessage();
    exit;
}
?>

<div class="card">
    <div class="card-header">
        <a name="" id="" class="btn btn-success" href="crear.php" role="button">Agregar adjunto</a>
    </div>
    <div class="card-body">
        <div class="table-responsive-sm">
            <table class="table" id="tabla_id">
                <thead>
                    <tr>
                        <th scope="col" width="2%">Ord</th>
                        <th scope="col" width="2%">Estado</th>
                        <th scope="col" width="20%">Adjunto</th>
                        <th scope="col" width="2%">Año</th>
                        <th scope="col" width="2%">Mes</th>
                        <th scope="col" width="2%">Tipo</th>
                        <th scope="col" width="8%">Fecha carga</th>
                        <th scope="col" width="8%">Fecha modificacion</th>
                        <th scope="col" width="8%">Usuario</th>
                        <th scope="col" width="25%">Opciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $registros->fetch(PDO::FETCH_ASSOC)) {
                        // Obtengo tipo de archivo
                        $tipo = pathinfo($row["nombrearchivo"], PATHINFO_EXTENSION);
                        ?>
                        <tr class="">
                            <td scope="row">
                                <?php echo $row["orden"]; ?>
                            </td>
                            <td>
                                <?php echo GetEstadoAdjunto($row["estado"], $row["idadjunto"]); ?>
                            </td>
                            <td>
                                <?php echo $row["adjunto"]; ?>
                            </td>
                            <td>
                                <?php echo $row["anio"]; ?>
                            </td>
                            <td>
                                <?php echo GetNombreMes($row["mes"]); ?>
                            </td>
                            <td>
                                <?php echo $tipo; ?>
                            </td>
                            <td>
                                <?php echo $row["fechacarga"]; ?>
                            </td>
                            <td>
                                <?php echo $row["fechamodificacion"]; ?>
                            </td>
                            <td>
                                <?php echo $row["nombreusuario"]; ?>
                            </td>
                            <td>
                                <!-- Envío idadjunto como hidden para la edición del registro-->
                                <input type="hidden" id="idadjunto" name="idadjunto"
                                    value="<?php echo $row["idadjunto"]; ?>">

                                <!-- Botón Editar-->
                                <a class="btn btn-success <?php echo ($row["estado"] == '1') ? 'disabled' : ''; ?>"
                                    href="editar.php?idadjunto=<?php echo $row["idadjunto"]; ?>" role="button"
                                    title="Editar registro"><i class="fa-solid fa-edit"></i></a>

                                <!-- Botón Eliminar-->
                                <button class="btn btn-danger <?php echo ($row["estado"] == '1') ? 'disabled' : ''; ?>"
                                    onclick='eliminar_archivo("<?php echo $row["idarchivo"]; ?>", "<?php echo $row["nombrearchivo"]; ?>")'
                                    title="Eliminar registro"><i class="fa fa-trash"></i></button>

                                <!-- Botón VerPDF-->
                                <button class="btn btn-dark" data-bs-toggle='modal' data-bs-target='#modalPDF'
                                    data-bs-tipo="<?php echo $tipo; ?>" data-bs-nombre="<?php echo $row["adjunto"]; ?>"
                                    data-bs-url="<?php echo $url_repositorio . $row["nombrearchivo"]; ?>"
                                    title="Revisar registro"><i
                                        class="<?php echo ($tipo == 'zip') ? 'fa-solid fa-file-zipper' : 'fa-solid fa-file-pdf'; ?>"></i></button>

                                <!-- Botón Enlazar-->
                                <button class="btn btn-warning"
                                    onclick='enlace("<?php echo $row["estado"]; ?>","<?php echo $row["idadjunto"]; ?>")'
                                    <?php echo ($row["estado"] == '1') ? 'hidden' : 'show'; ?>>
                                    <i class="fa-solid fa-link-slash"></i></button>

                                <!-- Botón Ver Enlace-->
                                <button class="btn btn-success" data-bs-toggle='modal' data-bs-target='#modalVentana'
                                    data-bs-nombre="<?php echo $row["adjunto"]; ?>"
                                    data-bs-url="<?php echo $url_repositorio . $row["nombrearchivo"]; ?>" <?php echo ($row["estado"] == '0') ? 'hidden' : 'show'; ?>>
                                    <i class="fa-solid fa-link"></i></button>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer text-muted">
        Descripción: Archivos adjuntos que se vincularán en las matrices.
    </div>

    <!-- Modal Ventana -->
    <div class="modal fade" id="modalVentana" tabindex="-1" aria-labelledby="modalVentanaLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalVentanaLabel">Ver enlace de archivo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info" id="estadoModal" name="estadoModal"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Ventana PDF -->
    <div class="modal fade" id="modalPDF" tabindex="-1" aria-labelledby="modalVentanaLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalVentanaLabel">Ver enlace de archivo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Mostrar ventanas modales -->
<script>

    // Ventana de Link
    var modalVentana = document.getElementById('modalVentana');
    modalVentana.addEventListener('show.bs.modal', function (event) {
        // Button that triggered the modal
        var button = event.relatedTarget;
        // Extract info from data-bs-* attributes        
        var nombre = button.getAttribute('data-bs-nombre');
        var url = button.getAttribute('data-bs-url');
        // Get components
        var modalTitle = modalVentana.querySelector('.modal-title');
        var modalBodyInput = modalVentana.querySelector('.modal-body #estadoModal');
        // Set info
        modalTitle.textContent = 'Enlace de archivo: ' + '"' + nombre + '"';
        modalBodyInput.innerHTML = "<a href='" + url + "' target='_blank'>" + url + "</a>";
    });

    // Ventana de PDF
    var modalPDF = document.getElementById('modalPDF');
    modalPDF.addEventListener('show.bs.modal', function (event) {
        // Button that triggered the modal
        var button = event.relatedTarget;
        // Extract info from data-bs-* attributes
        var tipo = button.getAttribute('data-bs-tipo');
        var nombre = button.getAttribute('data-bs-nombre');
        var url = button.getAttribute('data-bs-url');
        // Set info
        var modalTitle = modalPDF.querySelector('.modal-title');
        var modalBodyInput = modalPDF.querySelector('.modal-body');
        modalTitle.textContent = 'Archivo: ' + '"' + nombre + '"';
        if (tipo == 'zip') {
            modalBodyInput.innerHTML = '<h4>Descargar archivo </h4> <a class="btn btn-primary" href="' + url + '" role="button">Descargar</a>';
        } else {
            modalBodyInput.innerHTML = "<embed src='" + url + "' frameborder='0' width='100%' height='400px'>";
        }
    });

</script>

<!--Validaciones y funciones JavaScript-->
<script language="javascript">

    // Función de enlace
    const enlace = async function (estado, idadjunto) {
        // Estado = 0 :: Borrador
        if (estado == 0) {
            var opcion = confirm("¿Esta seguro que desea crear el enlace? IMPORTANTE: Luego de crear el enlace Usted no podrá editar ni eliminar el adjunto.");
            if (opcion == true) {
                const formData = new FormData();
                // Enviamos por POST
                formData.append("idadjunto", idadjunto);
                const respuestaRaw = await fetch("./cambiarestado.php", {
                    method: "POST",
                    body: formData,
                });
                const respuesta = await respuestaRaw.json();
                // Sacamos el resultado por consola
                console.log({ respuesta });
                window.location.reload();
            }
        }
    };

    // Función para Eliminar registro
    const eliminar_archivo = async function (idarchivo, nombrearchivo) {
        // Preparamos el formdata
        var opcion = confirm("¿Esta seguro que desea eliminar éste registro?");
        if (opcion == true) {
            const formData = new FormData();
            // Enviamos por POST
            formData.append("idarchivo", idarchivo);
            formData.append("nombrearchivo", nombrearchivo);
            const respuestaRaw = await fetch("./eliminar.php", {
                method: "POST",
                body: formData,
            });
            const respuesta = await respuestaRaw.json();
            // Sacamos el resultado por consola
            console.log({ respuesta });
            window.location.reload();
        }
    };

</script>
<?php
include_once(TEMPLATE_PATH . "footer.php");
?>