<?php
// Direccionamiento dinámico (Obligatorio)
include_once($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once(TEMPLATE_PATH . "header.php");
// Definicion de variables
$repositorio = $url_base . 'repositorio/';
// Obtengo variables de POST
$idgestion = $_SESSION["idgestion"];
$sentencia = "SELECT ROW_NUMBER() OVER (ORDER BY dm.orden ASC) AS orden, CONCAT(abrev,') ', dm.descripcion) AS matriz, f.idformato, ar.idarchivo, ar.nombrearchivo, fecha, observacion, f.estado
    FROM formatos f INNER JOIN archivos ar ON f.idarchivo=ar.idarchivo INNER JOIN descrip_matriz dm ON f.iddescripmat=dm.iddescripmat    
    WHERE  dm.estado=1 AND f.estado=1";
$registros = $db->prepare($sentencia);
$registros->bindParam(":idgestion", $idgestion);
$registros->execute();
?>
<div class="card">
    <div class="card-header">
        <a name="" id="" class="btn btn-success" href="crear.php" role="button">Agregar formato</a>
    </div>
    <div class="card-body">
        <div class="table-responsive-sm">
            <table class="table" id="tabla_id">
                <thead>
                    <tr>
                        <th scope="col" width="2%">Ord</th>
                        <th scope="col" width="20%">Documento</th>
                        <th scope="col" width="8%">Fecha</th>
                        <th scope="col" width="8%">Observacion</th>
                        <th scope="col" width="20%">Opciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $registros->fetch(PDO::FETCH_ASSOC)) {
                        ?>
                        <tr class="">
                            <td scope="row">
                                <?php echo $row["orden"]; ?>
                            </td>
                            <td>
                                <?php echo $row["matriz"]; ?>
                            </td>
                            <td>
                                <?php echo $row["fecha"]; ?>
                            </td>
                            <td>
                                <?php echo $row["observacion"]; ?>
                            </td>
                            <td>
                                <!-- Botón editar -->
                                <a class="btn btn-primary" href="editar.php?idformato=<?php echo $row["idformato"]; ?>"
                                    role="button">Editar <i class="fa-solid fa-edit"></i></a>
                                <!-- Botón eliminar -->
                                <button class="btn btn-danger" type="button" value="Eliminar"
                                    onclick='eliminar_archivo("<?php echo $row["idarchivo"]; ?>", "<?php echo $row["nombrearchivo"]; ?>")'>Eliminar
                                    <i class="fa fa-trash"></i></button>
                                <!-- Botón descargar -->
                                <input name="" id="" class="btn btn-secondary" type="button" value="Descargar"
                                    onclick='descargar("<?php echo $repositorio.$row["nombrearchivo"]; ?>")'>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer text-muted">
        Descripción: Formatos de las matrices obligatorias.
    </div>
</div>

<!--Validaciones y funciones JavaScript-->
<script language="javascript">
    // Función para Eliminar registro
    const eliminar_archivo = async function (idarchivo, nombrearchivo) {
        // Preparamos el formdata
        var opcion = confirm("¿Esta seguro que desea eliminar éste registro?");
        if (opcion == true) {
            const formData = new FormData();
            // Enviamos por POST
            formData.append("idarchivo", idarchivo);
            formData.append("nombrearchivo", nombrearchivo);
            const respuestaRaw = await fetch("./eliminar.php", {
                method: "POST",
                body: formData,
            });
            const respuesta = await respuestaRaw.json();
            // Sacamos el resultado por consola
            console.log({ respuesta });
            window.location.reload();
        }
    };
    // Función para descargar el archivo
    const descargar = async function (link) {        
        window.open(link, "_blank");
    };
</script>

<?php
include_once(TEMPLATE_PATH . "footer.php");
?>