<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH . "header.php");
// Variables
$anio_inicio = date('Y');
$mes_inicio = date('m') - 1;
$prefijo = 'mat_';
$path_respositorio = dirname(__FILE__, 4) . '/repositorio/';
$resultado = '';

// Variables de SESSION
$idusuario = $_SESSION["idusuario"];
$idgestion = $_SESSION["idgestion"];
$nombregestion = $_SESSION["gestion"];

// Obtengo listado de gestiones
try {
    $select_stmt = $db->prepare("SELECT * FROM gestiones");
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
$gestiones = $select_stmt->fetchAll(PDO::FETCH_ASSOC);

// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    // Instancio un objeto tipo datetime para obtener el Timestamp
    $fecha = new DateTime();
    // Nombre de archivo temporal
    $archivo_tmp_nombre = $_FILES['archivo']['tmp_name'];
    // Obtengo extension de archivo temporal
    $archivo_tmp_ext = strtolower(pathinfo($_FILES["archivo"]["name"], PATHINFO_EXTENSION));
    // Genero nombre de archivo final con nombre único
    $nombrearchivo = $prefijo . uniqid() . $fecha->getTimestamp() . '.' . $archivo_tmp_ext;
    $anio = (isset($_POST['txtAnio']) ? $_POST['txtAnio'] : $resultado .= 'No se registro año.');
    $mes = (isset($_POST['txtMes']) ? $_POST['txtMes'] : $resultado .= 'No se registro mes.');
    $iddescripmat = (isset($_POST['txtMatrices']) ? $_POST['txtMatrices'] : $resultado .= 'No se registro descripción de adjunto.');
    // Consulto si es una matriz duplicada
    try {
        $sql_stmt = $db->prepare("SELECT * FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat 
            INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo 
            WHERE anio=:anio AND mes=:mes AND dm.iddescripmat=:iddescripmat AND dm.estado=1;");
        $sql_stmt->bindParam(":iddescripmat", $iddescripmat);
        $sql_stmt->bindParam(":anio", $anio);
        $sql_stmt->bindParam(":mes", $mes);
        // Ejecución de la consulta
        $sql_stmt->execute();
    } catch (Exception $ex) {
        $resultado .= $ex->getMessage();
    }
    // Transfiero datos de la consulta en la variable $datos
    $datos = $sql_stmt->fetchAll(PDO::FETCH_ASSOC);

    // Consulto datos de matriz
    try {
        $sql_stmt = $db->prepare("SELECT orden FROM descrip_matriz WHERE iddescripmat=:iddescripmat AND estado=1");
        $sql_stmt->bindParam(":iddescripmat", $iddescripmat);
        // Ejecución de la consulta
        $sql_stmt->execute();
    } catch (Exception $ex) {
        $resultado .= $ex->getMessage();
    }
    // Transfiero datos de la consulta en la variable $orden
    $orden = $sql_stmt->fetch(PDO::FETCH_ASSOC)['orden'];

    if (count($datos) == 0) {
        // Matriz con orden 0 :: Plantillas LOTAIP 2024
        // Plantillas LOTAIP 2024 se publican directamente        
        if ($orden == '0') {
            $estado_publicado = 3;
        } else {
            $estado_publicado = 0;
        }
        // Carga de archivo
        if ($archivo_tmp_nombre != '') {
            move_uploaded_file($archivo_tmp_nombre, $path_respositorio . $nombrearchivo);
        } else {
            $resultado .= 'Error, no se pudo subir el archivo al repositorio.';
        }
        // Inserto datos en tabla archivos
        try {
            $insert_stmt = $db->prepare("INSERT INTO archivos (idarchivo, nombrearchivo, anio, mes, fechahoracarga, estado) 
            VALUES (NULL, :nombrearchivo, :anio, :mes, now(), 1)");
            //Parametros de inserción
            $insert_stmt->bindParam(":nombrearchivo", $nombrearchivo);
            $insert_stmt->bindParam(":anio", $anio);
            $insert_stmt->bindParam(":mes", $mes);
            // Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
            exit;
        }
        // Inserto datos en tabla matrices
        try {
            $insert_stmt = $db->prepare("INSERT INTO matrices (idmatriz, idusuario, iddescripmat, idarchivo, fechamodificacion, estado) 
            VALUES (NULL, :idusuario, :iddescripmat, (SELECT MAX(idarchivo) from archivos), now(), :estado_publicado)");
            //Parametros de inserción
            $insert_stmt->bindParam(":idusuario", $idusuario);
            $insert_stmt->bindParam(":iddescripmat", $iddescripmat);
            $insert_stmt->bindParam(":estado_publicado", $estado_publicado);
            //Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Verifica la inserción correcta y carga del archivo
        if ($insert_stmt) {
            $resultado .= "Archivo cargado exitosamente.";
        }
        // Imprime los resultados del proceso de carga
        echo '<div class="alert alert-success">' . $resultado . '</div>';
    } else {
        $resultado .= "ERROR: La matriz ya existe, favor verificar.";
        // Imprime los resultados del proceso de carga
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>

<div class="card">
    <div class="card-header">
        <h4>Agregar matriz</h4>
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="txtGestion" class="form-label">Gestión</label>
                <select class="form-select form-select-lg" name="txtGestion" id="txtGestion" required>
                    <option value="" selected>Seleccione una Gestión</option>
                    <?php
                    foreach ($gestiones as $g) {
                        ?>
                        <option value="<?php echo $g['idgestion']; ?>"><?php echo $g['descripcion']; ?></option>
                        <?php
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="txtMatrices" class="form-label">Matriz</label>
                <select class="form-select form-select-lg" name="txtMatrices" id="txtMatrices" required>
                </select>
            </div>
            <div class="mb-3">
                <label for="txtAnio" class="form-label">Año</label>
                <select class="form-select form-select-lg" name="txtAnio" id="txtAnio">
                    <?php
                    for ($i = 1; $i <= 5; $i++) {
                        ?>
                        <option value="<?php echo $anio_inicio; ?>"><?php echo $anio_inicio; ?></option>
                        <?php
                        $anio_inicio--;
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="txtMes" class="form-label">Mes</label>
                <select class="form-select form-select-lg" name="txtMes" id="txtMes">
                    <?php
                    for ($i = 1; $i <= 12; $i++) {
                        if ($i == $mes_inicio) {
                            ?>
                            <option value="<?php echo $i; ?>" selected><?php echo GetNombreMes($i); ?></option>
                            <?php
                        } else {
                            ?>
                            <option value="<?php echo $i; ?>"><?php echo GetNombreMes($i); ?></option>
                            <?php
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label" for="archivo">Archivo</label>
                <input type="file" class="form-control" id="archivo" name="archivo" accept=".zip, .pdf" required>
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Agregar matriz</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<script language="javascript">
    //Muestra listado de matrices por gestion
    $(document).ready(function () {
        $("#txtGestion").on('change', function () {
            $("#txtGestion option:selected").each(function () {
                idgestion = $(this).val();
                $.post("matrices.php", { idgestion: idgestion }, function (data) {
                    $("#txtMatrices").html(data);
                });
            });
        });
    });
</script>
<!---Validación de carga de archivos .zip--->
<script language='javascript'>
    $("#archivo").on("change", (e) => {
        const archivo = $(e.target)[0].files[0];
        let nombArchivo = archivo.name;
        var extension = nombArchivo.split(".").slice(-1);
        extension = extension[0];
        let extensiones = ["zip", "pdf", "ZIP", "PDF"];
        if (extensiones.indexOf(extension) === -1) {
            alert("Error: Sólo se aceptan archivos con extensión zip y pdf.");
            const $elemento = document.querySelector("#archivo");
            $elemento.value = "";
        }
    });
</script>
<?php
include_once (TEMPLATE_PATH . "footer.php");
?>