<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH . "header.php");
// Variables
$anio_inicio = date('Y') - 5;
$prefijo = 'mat_';
$path_respositorio = dirname(__FILE__, 4) . '/repositorio/';
$resultado = '';
// Variables de SESSION
$idusuario = $_SESSION["idusuario"];
// Variables de POST
$idmatriz = $_GET["idmatriz"];
// Obtengo datos del formulario
try {
    $select_stmt = $db->prepare("SELECT g.idgestion, g.descripcion AS gestion, dm.iddescripmat, CONCAT(abrev,') ', dm.descripcion) AS descripcion, 
            ar.idarchivo, ar.nombrearchivo, anio, mes, dm.orden
        FROM matrices m INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat INNER JOIN gestiones g
        ON dm.idgestion=g.idgestion
        WHERE m.idmatriz=:idmatriz AND dm.estado=1");
    $select_stmt->bindParam(":idmatriz", $idmatriz);
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
// Transfiero datos de la consulta en la variable $datos
$datos = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
// Obtengo información de variables de consulta
$idgestion = $datos[0]['idgestion']; // 1-Nombre de gestion
$nombregestion = $datos[0]['gestion']; // 1-Nombre de gestion
$iddescripmat = $datos[0]['iddescripmat'];
$descripmatriz = $datos[0]['descripcion'];
$idarchivo = $datos[0]['idarchivo'];
$nombrearchivo = $datos[0]['nombrearchivo'];
$anio_orig = $datos[0]['anio'];
$mes_orig = $datos[0]['mes'];
$orden = $datos[0]['orden'];
// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    // Instancio un objeto tipo datetime para obtener el Timestamp
    $fecha = new DateTime();
    // Obtengo variables de POST actualizadas
    $anio = (isset($_POST['txtAnio']) ? $_POST['txtAnio'] : $resultado .= 'No se registro año.');
    $mes = (isset($_POST['txtMes']) ? $_POST['txtMes'] : $resultado .= 'No se registro mes.');
    $estado_mat = (isset($_POST['txtEstado']) ? $_POST['txtEstado'] : $resultado .= 'No se registro estado.');
    // Consulto si es una matriz duplicada
    try {
        $sql_stmt = $db->prepare("SELECT * FROM matrices m INNER JOIN descrip_matriz dm ON m.iddescripmat=dm.iddescripmat INNER JOIN archivos ar ON m.idarchivo=ar.idarchivo
            WHERE anio=:anio AND mes=:mes AND dm.iddescripmat=:iddescripmat AND m.idmatriz<>:idmatriz AND dm.estado=1;");
        $sql_stmt->bindParam(":idmatriz", $idmatriz);
        $sql_stmt->bindParam(":iddescripmat", $iddescripmat);
        $sql_stmt->bindParam(":anio", $anio);
        $sql_stmt->bindParam(":mes", $mes);
        // Ejecución de la consulta
        $sql_stmt->execute();
    } catch (Exception $ex) {
        $resultado .= $ex->getMessage();
    }
    // Transfiero datos de la consulta
    $datos = $sql_stmt->fetchAll(PDO::FETCH_ASSOC);
    // Verifico que no haya resultados
    if (count($datos) == 0) {
        // Verifico si existe cambio de archivo        
        if ($_FILES['archivo']['tmp_name'] != '') {
            // Elimino el archivo original del repositorio
            unlink($path_respositorio . $nombrearchivo);
            // Obtengo nombre de archivo temporal
            $archivo_tmp_nombre = $_FILES['archivo']['tmp_name'];
            // Obtengo extension de archivo temporal
            $archivo_tmp_ext = strtolower(pathinfo($_FILES["archivo"]["name"], PATHINFO_EXTENSION));
            // Genero nombre de archivo final con nombre único
            $nombrearchivo = $prefijo . uniqid() . $fecha->getTimestamp() . '.' . $archivo_tmp_ext;
            move_uploaded_file($archivo_tmp_nombre, $path_respositorio . $nombrearchivo);
            $resultado .= "Se ha cargado un nuevo archivo.<br>";
        } else {
            $resultado .= "No se ha cargado nuevo archivo.<br>";
        }
        // Actualizo datos en tabla archivos
        try {
            $insert_stmt = $db->prepare("UPDATE archivos SET nombrearchivo=:nombrearchivo, anio=:anio, mes=:mes WHERE idarchivo=:idarchivo;");
            //Parametros de inserción
            $insert_stmt->bindParam(":idarchivo", $idarchivo);
            $insert_stmt->bindParam(":nombrearchivo", $nombrearchivo);
            $insert_stmt->bindParam(":anio", $anio);
            $insert_stmt->bindParam(":mes", $mes);
            // Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
            exit;
        }
        // Elimino registros de revision
        try {
            $delete_stmt = $db->prepare("DELETE FROM revisiones WHERE idmatriz=:idmatriz;");
            //Parametros de inserción            
            $delete_stmt->bindParam(":idmatriz", $idmatriz);
            //Ejecución de la consulta
            $delete_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Actualizo datos en tabla matriz
        try {
            $insert_stmt = $db->prepare("UPDATE matrices SET idusuario=:idusuario, fechamodificacion=now(), estado=:estado_mat WHERE idmatriz=:idmatriz;");
            //Parametros de inserción
            $insert_stmt->bindParam(":idusuario", $idusuario);
            $insert_stmt->bindParam(":idmatriz", $idmatriz);
            $insert_stmt->bindParam(":estado_mat", $estado_mat);
            //Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Verifica la inserción correcta y carga del archivo
        if ($insert_stmt) {
            $resultado .= "Registro actualizado exitosamente.";
        }
        // Imprime los resultados del proceso de carga
        echo '<div class="alert alert-success">' . $resultado . '</div>';
    } else {
        $resultado .= "ERROR: La matriz ya existe, favor verificar.";
        // Imprime los resultados del proceso de carga
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>
<div class="card">
    <div class="card-header">
        EDITAR MATRIZ
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label class="form-label" for="txtGestion">Gestión</label>
                <input type="text" id="txtGestion" name="txtGestion" class="form-control"
                    value="<?php echo $nombregestion; ?>" disabled />
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtMatriz">Matriz</label>
                <input type="text" id="txtMatriz" name="txtMatriz" class="form-control"
                    value="<?php echo $descripmatriz; ?>" disabled />
            </div>
            <div class="mb-3">
                <label for="txtEstado" class="form-label">Estado</label>
                <select class="form-select form-select-lg" name="txtEstado" id="txtEstado">
                    <?php if ($orden == 0) { ?>
                        <option value="3" selected>Publicado</option>
                    <?php } else { ?>
                        <option value="0" selected>Borrador</option>
                    <?php } ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="txtAnio" class="form-label">Año</label>
                <select class="form-select form-select-lg" name="txtAnio" id="txtAnio">
                    <?php
                    for ($i = 1; $i <= 5; $i++) {
                        $anio_inicio++;
                        if ($anio_inicio == $anio_orig) {
                            ?>
                            <option value="<?php echo $anio_inicio; ?>" selected>
                                <?php echo $anio_inicio; ?>
                            </option>
                            <?php
                        } else {
                            ?>
                            <option value="<?php echo $anio_inicio; ?>">
                                <?php echo $anio_inicio; ?>
                            </option>
                            <?php
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="txtMes" class="form-label">Mes</label>
                <select class="form-select form-select-lg" name="txtMes" id="txtMes">
                    <?php
                    for ($i = 1; $i <= 12; $i++) {
                        if ($i == $mes_orig) {
                            ?>
                            <option value="<?php echo $i; ?>" selected>
                                <?php echo GetNombreMes($i); ?>
                            </option>
                            <?php
                        } else {
                            ?>
                            <option value="<?php echo $i; ?>">
                                <?php echo GetNombreMes($i); ?>
                            </option>
                            <?php
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label" for="archivo">Archivo</label>
                <input type="file" class="form-control" id="archivo" name="archivo" accept=".zip, .pdf">
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Actualizar matriz</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<!---Validación de carga de archivos .zip--->
<script language='javascript'>
    $("#archivo").on("change", (e) => {
        const archivo = $(e.target)[0].files[0];
        let nombArchivo = archivo.name;
        var extension = nombArchivo.split(".").slice(-1);
        extension = extension[0];
        let extensiones = ["zip", "pdf", "ZIP", "PDF"];
        if (extensiones.indexOf(extension) === -1) {
            alert("Error: Sólo se aceptan archivos con extensión zip y pdf.");
            const $elemento = document.querySelector("#archivo");
            $elemento.value = "";
        }
    });
</script>
<?php
include_once (TEMPLATE_PATH . "footer.php");
?>