<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
if (isset($_REQUEST['btnCambiar'])) {
    $txtClaveActual = $_REQUEST["txtClaveActual"];
    $txtNuevaClave1 = $_REQUEST["txtNuevaClave1"];
    $txtNuevaClave2 = $_REQUEST["txtNuevaClave2"];
    $idusuario = $_SESSION["idusuario"];
    $usuario = $_SESSION["usuario"];
    if (!empty($txtClaveActual) && !empty($txtNuevaClave1) && !empty($txtNuevaClave2)) {
        if ($txtNuevaClave1 == $txtNuevaClave2) {
            try {
                $select_stmt = $db->prepare("SELECT * FROM usuarios WHERE idusuario=:idusuario AND clave=SHA1(:clave)");
                $select_stmt->bindParam(":idusuario", $idusuario);
                $select_stmt->bindParam(":clave", $txtClaveActual);
                $select_stmt->execute();
            } catch (PDOException $e) {
                $errorMsg[] = array("ERROR 001: " . $e->getMessage(), "alert alert-danger");
            }
            if ($select_stmt->rowCount() > 0) {
                // Actualizamos la clave del usuario
                try {
                    $update_stmt = $db->prepare("UPDATE usuarios SET clave=SHA1(:clave) WHERE idusuario=:idusuario");
                    $update_stmt->bindParam(":idusuario", $idusuario);
                    $update_stmt->bindParam(":clave", $txtNuevaClave1);
                    $update_stmt->execute();
                } catch (PDOException $e) {
                    $errorMsg[] = array("ERROR 001: " . $e->getMessage(), "alert alert-danger");
                }
                if ($update_stmt->rowCount() > 0) {
                    $errorMsg[] = array("La clave se ha cambiado correctamente.", "alert alert-success");
                    @session_start();
                    session_destroy();
                    session_unset();
                }
            } else {
                $errorMsg[] = array("La clave actual no es correcta.", "alert alert-danger");
            }
        } else {
            $errorMsg[] = array("Las nuevas claves ingresadas no coinciden.", "alert alert-danger");
        }
    } else {
        $errorMsg[] = array("Debe ingresar todos los datos marcados como obligatorios.", "alert alert-danger");
    }

    if (isset($errorMsg)) {
        foreach ($errorMsg as $error) {
            ?>
            <div class="<?php echo $error[1]; ?>">
                <strong>
                    <?php echo $error[0]; ?>
                </strong>
            </div>
            <?php
        }
    }
}
?>
<div class="card">
    <div class="card-header">
        <h4 class="card-title">Cambiar de clave</h4>
    </div>
    <div class="card-body">
        <div class="login-form">
            <form method="post">
                <!-- Usuario input -->
                <div class="form-outline mb-4">
                    <label class="form-label" for="txtClaveActual">Clave actual</label>
                    <input type="password" id="txtClaveActual" name="txtClaveActual" class="form-control"
                        placeholder="Ingrese su clave actual" required />
                </div>
                <!-- Clave input -->
                <div class="form-outline mb-4">
                    <label class="form-label" for="txtNuevaClave1">Nueva clave</label>
                    <input type="password" id="txtNuevaClave1" name="txtNuevaClave1" class="form-control"
                        placeholder="Ingrese nueva clave" required />
                </div>
                <!-- Repita su Clave input -->
                <div class="form-outline mb-4">
                    <label class="form-label" for="txtNuevaClave2">Repita nueva clave</label>
                    <input type="password" id="txtNuevaClave2" name="txtNuevaClave2" class="form-control"
                        placeholder="Repita su nueva clave" required />
                </div>
                <!-- Submit button -->
                <button type="submit" name="btnCambiar" class="btn btn-success">Cambiar clave</button>
                <!-- Volver button -->
                <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
            </form>
        </div>
    </div>
    <div class="card-footer text-muted">
        Descripción: Aquí puede cambiar su clave de acceso actual.
    </div>
</div>
<?php
include_once (TEMPLATE_PATH."footer.php");
?>