<?php
// Iniciamos variables de session
session_start();
// Direccionamiento dinamico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (CONF_PATH."db.php");
// Definicion de variables
$dbusuario = '';
// Verifico si esta iniciada sesion
if (isset($_SESSION["usuario"])) {
    header("location: ../../secciones/main/index.php");
}
if ($_POST) {
    $usuario = $_REQUEST["txt_usuario"];
    $clave = $_REQUEST["txt_password"];
    if ($usuario == '' || $clave == '') {
        $errorMsg[] = "Debe ingresar su usuario y clave.";
    } else {
        try {
            $select_stmt = $db->prepare("SELECT u.idusuario, nombre, usuario, u.estado AS estado_usuario, g.idgestion, g.descripcion AS gestion, idmiembro_comision, 
                privilegios, mc.aprobador, mc.estado AS estado_aprobador FROM usuarios u INNER JOIN gestiones g ON u.idgestion=g.idgestion LEFT JOIN miembros_comision mc 
                ON u.idusuario=mc.idusuario WHERE usuario=:usuario AND clave=SHA1(:clave)");
            $select_stmt->bindParam(":usuario", $usuario);
            $select_stmt->bindParam(":clave", $clave);
            $select_stmt->execute();
            if ($select_stmt->rowCount() > 0) {
                while ($row = $select_stmt->fetch(PDO::FETCH_ASSOC)) {
                    $dbidusuario = $row["idusuario"];
                    $dbnombre = $row["nombre"];
                    $dbusuario = $row["usuario"];
                    $dbestado_usuario = $row["estado_usuario"];
                    $dbidgestion = $row["idgestion"];
                    $dbgestion = $row["gestion"];
                    $dbidmiembro = $row["idmiembro_comision"];
                    $dbprivilegios = $row["privilegios"];
                    $dbaprobador = $row["aprobador"];
                    $dbestado_aprobador = $row["estado_aprobador"];
                }
                if ($dbestado_usuario == 1) {
                    $_SESSION["idusuario"] = $dbidusuario;
                    $_SESSION["nombre"] = $dbnombre;
                    $_SESSION["usuario"] = $dbusuario;
                    $_SESSION["estado_usuario"] = $dbestado_usuario;
                    $_SESSION["idgestion"] = $dbidgestion;
                    $_SESSION["gestion"] = $dbgestion;
                    $_SESSION["idmiembro"] = $dbidmiembro;
                    $_SESSION["privilegios"] = $dbprivilegios;
                    $_SESSION["aprobador"] = $dbaprobador;
                    $_SESSION["estado_aprobador"] = $dbestado_aprobador;
                    header("Location: ../../secciones/main/index.php");
                } else {
                    $errorMsg[] = "El usuario se encuentra inactivo.";
                }
            } else {
                $errorMsg[] = "Usuario o contraseña incorrecta.";
            }
        } catch (PDOException $e) {
            $e->getMessage();
        }
        // Para bloqueo temporal
        //$errorMsg[] ="El sistema se encuentra en mantenimiento y actualizacion, se informara oportunamente cuando se encuentre disponible.";
    }
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="initial-scale=1.0, maximum-scale=2.0">
    <title>Login</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM"
        crossorigin="anonymous"></script>
    <style type="text/css">
        .login-form {
            width: 340px;
            margin: 20px auto;
        }

        .login-form form {
            margin-bottom: 15px;
            background: #f7f7f7;
            box-shadow: 0px 2px 2px rgba(0, 0, 0, 0.3);
            padding: 30px;
        }

        .login-form h2 {
            margin: 0 0 15px;
        }

        .form-control,
        .btn {
            min-height: 38px;
            border-radius: 2px;
        }

        .btn {
            font-size: 15px;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="col-lg-12">
            <?php
            if (isset($errorMsg)) {
                foreach ($errorMsg as $error) {
                    ?>
                    <div class="alert alert-danger">
                        <strong>
                            <?php echo $error; ?>
                        </strong>
                    </div>
                    <?php
                }
            }
            ?>
            <div class="login-form">
                <center>
                    <h2>Iniciar sesión</h2>
                </center>
                <form method="post">
                    <!-- Usuario input -->
                    <div class="form-outline mb-4">
                        <label class="form-label" for="txt_usuario">Usuario</label>
                        <input type="text" id="txt_usuario" name="txt_usuario" class="form-control"
                            placeholder="Ingrese su usuario" />
                    </div>
                    <!-- Clave input -->
                    <div class="form-outline mb-4">
                        <label class="form-label" for="txt_password">Password</label>
                        <input type="password" id="txt_password" name="txt_password" class="form-control"
                            placeholder="Ingrese su password" />
                    </div>
                    <!-- Submit button -->
                    <button type="submit" name="btn_login" class="btn btn-primary">Iniciar sesión</button>
                </form>
            </div>
        </div>
    </div>
</body>

</html>