<?php
// Direccionamiento dinámico (Obligatorio)
include_once($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once(TEMPLATE_PATH . "header.php");
// Definicion de variables
$resultado = '';
$lista_estados = array('0' => 'Inactivo', '1' => 'Activo'); // Array de combo
// Variables de GET
$iddescripmat = $_GET['iddescripmat'];
// Obtengo lista de gestiones
try {
    $select_stmt = $db->prepare("SELECT idgestion, descripcion FROM gestiones WHERE estado=1");
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
// Transfiero datos de la consulta
$gestiones = $select_stmt->fetchAll(PDO::FETCH_ASSOC);

// Obtengo datos del registro a editar
$select_stmt = $db->prepare("SELECT dm.idgestion, abrev, dm.descripcion as nombre, g.descripcion as gestion, dm.orden, dm.estado 
    FROM descrip_matriz dm INNER JOIN gestiones g ON dm.idgestion=g.idgestion
    WHERE dm.iddescripmat=:iddescripmat AND dm.estado=1");
$select_stmt->bindParam(":iddescripmat", $iddescripmat);
$select_stmt->execute();
// Transfiero datos de la consulta
$matriz = $select_stmt->fetchAll(PDO::FETCH_ASSOC);

// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {    
    $idgestion = (isset($_POST['txtGestion']) ? $_POST['txtGestion'] : $resultado .= 'No se ingresa txtGestion');
    $abrev = (isset($_POST['txtAbrev']) ? $_POST['txtAbrev'] : $resultado .= 'No se ingresa txtAbrev');
    $nombre = (isset($_POST['txtNombre']) ? $_POST['txtNombre'] : $resultado .= 'No se ingresa txtNombre');
    $orden = (isset($_POST['txtOrden']) ? $_POST['txtOrden'] : $resultado .= 'No se ingresa txtOrden');
    $estado = (isset($_POST['txtEstado']) ? $_POST['txtEstado'] : $resultado .= 'No se ingresa txtEstado');
    // Comparo que no sea registro duplicado    
    try {
        $select_stmt = $db->prepare("SELECT * FROM descrip_matriz WHERE (abrev=:abrev OR descripcion=:nombre) AND iddescripmat<>:iddescripmat AND estado=1");
        $select_stmt->bindParam(":abrev", $abrev);
        $select_stmt->bindParam(":nombre", $nombre);
        $select_stmt->bindParam(":iddescripmat", $iddescripmat);
        $select_stmt->execute();
    } catch (PDOException $e) {
        $resultado .= $e->getMessage();
    }
    // Transfiero datos de la consulta
    $matrices = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
    // Comprueba si adjunto no existe en la base de datos    
    if (count($matrices) == 0) {
        // Inserto datos en tabla
        try {
            $update_stmt = $db->prepare("UPDATE descrip_matriz SET idgestion=:idgestion, abrev=:abrev, descripcion=:nombre, orden=:orden, estado=:estado 
                WHERE iddescripmat=:iddescripmat");
            //Parametros de inserción
            $update_stmt->bindParam(":idgestion", $idgestion);
            $update_stmt->bindParam(":abrev", $abrev);
            $update_stmt->bindParam(":nombre", $nombre);
            $update_stmt->bindParam(":orden", $orden);
            $update_stmt->bindParam(":estado", $estado);
            $update_stmt->bindParam(":iddescripmat", $iddescripmat);
            // Ejecución de la consulta
            $update_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Verifica la inserción correcta y carga del archivo
        if ($resultado == '') {
            $resultado .= "Registro actualizado exitosamente.";
            // Imprime los resultados del proceso de carga
            echo '<div class="alert alert-success">' . $resultado . '</div>';
        } else {
            $resultado .= "Error al actualizar registro.";
            // Imprime los resultados del proceso de carga
            echo '<div class="alert alert-danger">' . $resultado . '</div>';
        }
    } else {
        $resultado = "ERROR: Registro duplicado.";
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>
<div class="card">
    <div class="card-header">
        <h4>Editar descripción de Matriz</h4>
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="txtGestion" class="form-label">Gestión responsable:</label>
                <select class="form-select form-select-lg" name="txtGestion" id="txtGestion" required>
                    <option value="" selected>Seleccione una Gestión</option>
                    <?php
                    foreach ($gestiones as $g) {
                        if ($g['idgestion'] == $matriz[0]['idgestion']) {
                            echo '<option value="' . $g['idgestion'] . '" selected>' . $g['descripcion'] . '</option>';
                        } else {
                            echo '<option value="' . $g['idgestion'] . '">' . $g['descripcion'] . '</option>';
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtAbrev">Literal o abreviatura:</label>
                <input type="text" id="txtAbrev" name="txtAbrev" class="form-control"
                    placeholder="Digite el literal de la matriz (Ej: a1)"
                    onkeyup="javascript:this.value=this.value.toLowerCase();" value="<?php echo $matriz[0]['abrev']; ?>" required />
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtNombre">Nombre de matriz:</label>
                <input type="text" id="txtNombre" name="txtNombre" class="form-control"
                    placeholder="Describa el nombre de la matriz" value="<?php echo $matriz[0]['nombre']; ?>" required />
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtOrden">Orden:</label>
                <input type="number" id="txtOrden" name="txtOrden" class="form-control"
                    placeholder="Digite el orden de aparición en el listado de matrices" value="<?php echo $matriz[0]['orden']; ?>" required />
            </div>
            <div class="mb-3">
                <label for="txtEstado" class="form-label">Estado</label>
                <select class="form-select form-select-lg" name="txtEstado" id="txtEstado">
                    <?php
                    for ($i = 0; $i < count($lista_estados); $i++) {
                        if ($matriz[0]['estado'] == $i) {
                            echo '<option value="' . $i . '" selected>' . $lista_estados[$i] . '</option>';
                        } else {
                            echo '<option value="' . $i . '">' . $lista_estados[$i] . '</option>';
                        }
                    }
                    ?>
                </select>
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Actualizar descripción de Matriz</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<?php
include_once(TEMPLATE_PATH . "footer.php");
?>