<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
// Obtengo listado de gestiones
$registros = $db->prepare("SELECT ROW_NUMBER() OVER (ORDER BY descripcion DESC) AS 'orden', 
    idgestion, descripcion, estado FROM gestiones");
$registros->execute();
?>
<!-- Mensaje de notificacion de transacción-->
<div class="mensaje alert alert-danger" style="display:none;" id="mensaje">Estado</div>
<div class="card">
    <div class="card-header">
        <a name="" id="" class="btn btn-success" href="crear.php" role="button">Agregar Gestión</a>
    </div>
    <div class="card-body">
        <div class="table-responsive-sm">
            <table class="table" id="tabla_id">
                <thead>
                    <tr>
                        <th scope="col" width="5%">Ord</th>
                        <th scope="col" width="45%">Gestión</th>
                        <th scope="col" width="10%">Estado</th>
                        <th scope="col" width="30%">Opciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $registros->fetch(PDO::FETCH_ASSOC)) {
                        ?>
                        <tr class="">
                            <td scope="row">
                                <?php echo $row["orden"]; ?>
                            </td>
                            <td>
                                <?php echo $row["descripcion"]; ?>
                            </td>
                            <td>
                                <?php echo ($row["estado"] == 1) ? 'Activo' : 'Inactivo'; ?>
                            </td>
                            <td>
                                <!-- Botón editar -->
                                <a name="" id="" class="btn btn-primary"
                                    href="editar.php?idgestion=<?php echo $row["idgestion"]; ?>" role="button">Editar</a>
                                <!-- Botón eliminar -->
                                <input name="" id="" class="btn btn-danger" type="button" value="Eliminar"
                                    onclick='eliminar("<?php echo $row["idgestion"]; ?>", "<?php echo $row["descripcion"]; ?>")'>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer text-muted">
        Descripción: Gestiones responsables de cumplir con la LOTAIP.
    </div>
</div>

<!--Validaciones y funciones JavaScript-->
<script language="javascript">
    // Función para Eliminar registro
    const eliminar = async function (idgestion, gestion) {
        // Preparamos el formdata
        var opcion = confirm("¿Esta seguro que desea eliminar éste registro?");
        if (opcion == true) {
            const formData = new FormData();
            // Enviamos por POST
            formData.append("idgestion", idgestion);
            const respuestaRaw = await fetch("./eliminar.php", {
                method: "POST",
                body: formData,
            });
            const respuesta = await respuestaRaw.json();
            if (respuesta == 'Eliminado') {
                window.location.reload();               
            } else {
                // Sacamos el resultado por consola
                setTimeout(function () {
                    $("#mensaje").html("No puede eliminar " + gestion + ", esta siendo utilizada en otro registro.");
                    $(".mensaje").fadeIn(1000);
                }, 0);
                setTimeout(function () {
                    $(".mensaje").fadeOut(1000);
                }, 5000);
            }
        }
    };
</script>
<?php
include_once (TEMPLATE_PATH."footer.php");
?>