<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
// Definicion de variables
$resultado = '';
$op_aprobador = array('0' => 'No', '1' => 'Sí'); // Array de combo
$estados = array('0' => 'Inactivo', '1' => 'Activo'); // Array de combo
// Variables de POST
$idmiembro_comision = $_GET["idmiembro_comision"];

// Obtengo datos del formulario
try {
    $select_stmt = $db->prepare("SELECT mc.idmiembro_comision, u.idusuario, u.nombre, mc.cargo, mc.estado, mc.aprobador, mc.f_inicio_gestion 
        FROM miembros_comision mc INNER JOIN usuarios u ON mc.idusuario=u.idusuario WHERE idmiembro_comision=:idmiembro_comision");
    $select_stmt->bindParam(":idmiembro_comision", $idmiembro_comision);
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
// Transfiero datos de la consulta en la variable $datos
$datos = $select_stmt->fetchAll(PDO::FETCH_ASSOC);

// Obtengo listado de usuarios activos
try {
    $select_stmt = $db->prepare("SELECT * FROM usuarios");
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
// Transfiero datos de la consulta en la variable $datos
$usuarios = $select_stmt->fetchAll(PDO::FETCH_ASSOC);

// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    $idusuario = ((isset($_POST['txtUsuario']) && $_POST['txtUsuario'] != '') ? $_POST['txtUsuario'] : $resultado .= 'No se registra Usuario');
    $cargo = ((isset($_POST['txtCargo'])) ? $_POST['txtCargo'] : $resultado .= 'No se registra Cargo');
    $aprobador = ((isset($_POST['txtAprobador'])) ? $_POST['txtAprobador'] : $resultado .= 'No se registra Aprobador');
    $f_inicio_gestion = ((!empty($_POST['txtFecha'])) ? $_POST['txtFecha'] : $resultado .= 'No se registra Fecha Inicio Gestion');
    $estado = ((isset($_POST['txtEstado'])) ? $_POST['txtEstado'] : $resultado .= 'No se registra Estado');
    // Comparo que no sea registro duplicado
    try {
        $select_stmt = $db->prepare("SELECT * from miembros_comision WHERE cargo=:cargo AND idmiembro_comision<>:idmiembro_comision AND estado = 1");
        $select_stmt->bindParam(":cargo", $cargo);
        $select_stmt->bindParam(":idmiembro_comision", $idmiembro_comision);
        $select_stmt->execute();
    } catch (PDOException $e) {
        $resultado .= 'ERROR 001: ' . $e->getMessage();
    }
    // Transfiero datos de la consulta en la variable $miembros
    $miembros = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Comprueba si miembro existe en la base de datos
    if (count($miembros) == 0) {
        // Actualizo datos en tabla
        try {
            $update_stmt = $db->prepare("UPDATE miembros_comision SET idusuario=:idusuario, cargo=:cargo, aprobador=:aprobador, f_inicio_gestion=str_to_date(:f_inicio_gestion, '%Y-%m-%d %H:%i'), estado=:estado 
                WHERE idmiembro_comision=:idmiembro_comision");
            //Parametros de inserción
            $update_stmt->bindParam(":idusuario", $idusuario);
            $update_stmt->bindParam(":cargo", $cargo);
            $update_stmt->bindParam(":aprobador", $aprobador);
            $update_stmt->bindParam(":f_inicio_gestion", $f_inicio_gestion);
            $update_stmt->bindParam(":estado", $estado);
            $update_stmt->bindParam(":idmiembro_comision", $idmiembro_comision);
            // Ejecución de la consulta
            $update_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= 'ERROR 002: ' . $ex->getMessage();
        }
        // Verifica la inserción correcta
        if ($update_stmt != TRUE) {
            // Devuelve mensaje resultado erróneo            
            echo '<div class="alert alert-danger">' . "update_stmt: " . $update_stmt . ' RESULTADO: ' . $resultado . '</div>';
        } else {
            // Devuelve mensaje resultado exitoso
            $resultado .= "Registro actualizado exitosamente.";
            echo '<div class="alert alert-success">' . $resultado . '</div>';
        }

    } else {
        // Devuelve mensaje resultado erróneo
        $resultado = "ERROR: Registro duplicado.";
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>
<div class="card">
    <div class="card-header">
        Editar miembro de comisión
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="txtUsuario" class="form-label">Usuario</label>
                <select class="form-select form-select-lg" name="txtUsuario" id="txtUsuario">
                    <?php
                    foreach ($usuarios as $u) {
                        if ($u['idusuario'] == $datos[0]['idusuario']) {
                            echo '<option value="' . $u['idusuario'] . '" selected>' . $u['nombre'] . '</option>';
                        } else {
                            echo '<option value="' . $u['idusuario'] . '">' . $u['nombre'] . '</option>';
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtCargo">Cargo</label>
                <input multiple type="text" id="txtCargo" name="txtCargo" class="form-control"
                    placeholder="Ingrese el cargo" maxlength="250" style="text-transform:uppercase;"
                    onkeyup="javascript:this.value=this.value.toUpperCase();" value="<?php echo $datos[0]['cargo']; ?>"
                    required />
            </div>
            <div class="mb-3">
                <label for="txtAprobador" class="form-label">Aprobador</label>
                <select class="form-select form-select-lg" name="txtAprobador" id="txtAprobador">
                    <?php
                    for ($i = 0; $i < count($op_aprobador); $i++) {
                        if ($datos[0]['aprobador'] == $i) {
                            echo '<option value="' . $i . '" selected>' . $op_aprobador[$i] . '</option>';
                        } else {
                            echo '<option value="' . $i . '">' . $op_aprobador[$i] . '</option>';
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="txtFecha" class="form-label">Fecha de inicio de gestión</label>
                <input type="text" id="txtFecha" name="txtFecha"  value="<?php echo $datos[0]['f_inicio_gestion']; ?>" required/>
                <script>
                    $( "#txtFecha" ).datetimepicker({
                        locale: 'es-es',
                        uiLibrary: 'bootstrap5',
                        footer: true,
                        format: 'yyyy-mm-dd HH:MM:SS'
                    });
                </script>
            </div>
            <div class="mb-3">
                <label for="txtEstado" class="form-label">Estado</label>
                <select class="form-select form-select-lg" name="txtEstado" id="txtEstado">
                    <?php
                    for ($i = 0; $i < count($estados); $i++) {
                        if ($datos[0]['estado'] == $i) {
                            echo '<option value="' . $i . '" selected>' . $estados[$i] . '</option>';
                        } else {
                            echo '<option value="' . $i . '">' . $estados[$i] . '</option>';
                        }
                    }
                    ?>
                </select>
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Guardar</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<?php
include_once (TEMPLATE_PATH."footer.php");
?>