<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
// Obtengo listado de gestiones
$registros = $db->prepare("SELECT ROW_NUMBER() OVER (ORDER BY cargo DESC) AS 'orden', mc.idmiembro_comision, u.nombre, 
    mc.cargo, mc.estado, mc.aprobador FROM miembros_comision mc INNER JOIN usuarios u ON mc.idusuario=u.idusuario");
$registros->execute();
?>
<!-- Mensaje de notificacion de transacción-->
<div class="mensaje alert alert-danger" style="display:none;" id="mensaje">Estado</div>
<div class="card">
    <div class="card-header">
        <a name="" id="" class="btn btn-success" href="crear.php" role="button">Agregar miembro Comisión</a>
    </div>
    <div class="card-body">
        <div class="table-responsive-sm">
            <table class="table" id="tabla_id">
                <thead>
                    <tr>
                        <th scope="col" width="5%">Ord</th>
                        <th scope="col" width="15%">Cargo</th>
                        <th scope="col" width="15%">Nombre</th>
                        <th scope="col" width="5%">Aprobador</th>
                        <th scope="col" width="5%">Estado</th>
                        <th scope="col" width="20%">opciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $registros->fetch(PDO::FETCH_ASSOC)) {
                        ?>
                        <tr class="">
                            <td scope="row">
                                <?php echo $row["orden"]; ?>
                            </td>
                            <td>
                                <?php echo $row["cargo"]; ?>
                            </td>
                            <td>
                                <?php echo $row["nombre"]; ?>
                            </td>                                                        
                            <td>
                                <?php echo ($row["aprobador"] == 1) ? 'Sí' : 'No'; ?>
                            </td>
                            <td>
                                <?php echo ($row["estado"] == 1) ? 'Activo' : 'Inactivo'; ?>
                            </td>
                            <td>
                                <!-- Botón editar -->
                                <a name="" id="" class="btn btn-primary"
                                    href="editar.php?idmiembro_comision=<?php echo $row["idmiembro_comision"]; ?>" role="button">Editar</a>
                                <!-- Botón eliminar -->
                                <input name="" id="" class="btn btn-danger" type="button" value="Eliminar"
                                    onclick='eliminar("<?php echo $row["idmiembro_comision"]; ?>", "<?php echo $row["cargo"]; ?>")'>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer text-muted">
        Descripción: Miembros de la comisión desginados para el control de publicación.
    </div>
</div>

<!--Validaciones y funciones JavaScript-->
<script language="javascript">
    // Función para Eliminar registro
    const eliminar = async function (idmiembro_comision, cargo) {
        // Preparamos el formdata
        var opcion = confirm("¿Esta seguro que desea eliminar éste registro?");
        if (opcion == true) {
            const formData = new FormData();
            // Enviamos por POST
            formData.append("idmiembro_comision", idmiembro_comision);
            const respuestaRaw = await fetch("./eliminar.php", {
                method: "POST",
                body: formData,
            });
            const respuesta = await respuestaRaw.json();
            if (respuesta == 'Eliminado') {
                window.location.reload();               
            } else {
                // Sacamos el resultado por consola
                setTimeout(function () {
                    $("#mensaje").html("No puede eliminar " + cargo + ", esta siendo utilizada en otro registro.");
                    $(".mensaje").fadeIn(1000);
                }, 0);
                setTimeout(function () {
                    $(".mensaje").fadeOut(1000);
                }, 5000);
            }
        }
    };
</script>
<?php
include_once (TEMPLATE_PATH."footer.php");
?>