<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
// Definicion de variables
$resultado = '';
$lista_privilegios = array('0' => 'Operador', '1' => 'Responsable', '2' => 'Supervisor', '3' => 'Administrador');
// Obtengo lista de gestiones
try {
    $select_stmt = $db->prepare("SELECT idgestion, descripcion from gestiones");
    $select_stmt->execute();
} catch (PDOException $e) {
    $resultado .= $e->getMessage();
}
// Transfiero datos de la consulta
$gestiones = $select_stmt->fetchAll(PDO::FETCH_ASSOC);

// Proceso de grabacion una vez que se detecte el envío de variables POST
if ($_POST) {
    $gestion = (isset($_POST['txtGestion']) ? $_POST['txtGestion'] : $resultado .= 'No se ingresa Gestión');
    $nombre = (isset($_POST['txtNombre']) ? $_POST['txtNombre'] : $resultado .= 'No se ingresa Nombre');
    $usuario = (isset($_POST['txtUsuario']) ? $_POST['txtUsuario'] : $resultado .= 'No se ingresa Usuario');
    $clave = (isset($_POST['txtClave']) ? $_POST['txtClave'] : $resultado .= 'No se ingresa Clave');
    $correo = (isset($_POST['txtCorreo']) ? $_POST['txtCorreo'] : $resultado .= 'No se ingresa Correo');
    $privilegios = (isset($_POST['txtPrivilegios']) ? $_POST['txtPrivilegios'] : $resultado .= 'No se ingresa Privilegios');
    // Comparo que no sea registro duplicado    
    try {
        $select_stmt = $db->prepare("SELECT * FROM usuarios WHERE idgestion=:gestion AND nombre=:nombre AND usuario=:usuario");
        $select_stmt->bindParam(":gestion", $gestion);
        $select_stmt->bindParam(":nombre", $nombre);
        $select_stmt->bindParam(":usuario", $usuario);
        $select_stmt->execute();
    } catch (PDOException $e) {
        $resultado .= $e->getMessage();
    }
    // Transfiero datos de la consulta
    $usuarios = $select_stmt->fetchAll(PDO::FETCH_ASSOC);
    // Comprueba si adjunto no existe en la base de datos
    if (count($usuarios) == 0) {
        // Inserto datos en tabla
        try {
            $insert_stmt = $db->prepare("INSERT INTO usuarios (idusuario, idgestion, nombre, usuario, clave, privilegios, correo, estado) 
                VALUES (NULL, :gestion, :nombre, :usuario, SHA1(:clave), :privilegios, :correo, 1)");
            //Parametros de inserción
            $insert_stmt->bindParam(":gestion", $gestion);
            $insert_stmt->bindParam(":nombre", $nombre);
            $insert_stmt->bindParam(":usuario", $usuario);
            $insert_stmt->bindParam(":clave", $clave);
            $insert_stmt->bindParam(":privilegios", $privilegios);
            $insert_stmt->bindParam(":correo", $correo);                        
            // Ejecución de la consulta
            $insert_stmt->execute();
        } catch (Exception $ex) {
            $resultado .= $ex->getMessage();
        }
        // Verifica la inserción correcta y carga del archivo
        if ($resultado == '') {
            $resultado .= "Registro creado exitosamente.";
            // Imprime los resultados del proceso de carga
            echo '<div class="alert alert-success">' . $resultado . '</div>';
        } else {
            $resultado .= "Error al insertar el registro.";
            // Imprime los resultados del proceso de carga
            echo '<div class="alert alert-danger">' . $resultado . '</div>';
        }
    } else {
        $resultado = "ERROR: Registro duplicado.";
        echo '<div class="alert alert-danger">' . $resultado . '</div>';
    }
}
?>
<div class="card">
    <div class="card-header">
        <h4>Agregar nuevo usuario</h4>
    </div>
    <div class="card-body">
        <form action="" method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="txtGestion" class="form-label">Gestión</label>
                <select class="form-select form-select-lg" name="txtGestion" id="txtGestion" required>
                    <option value="" selected>Seleccione una Gestión</option>
                    <?php
                    foreach ($gestiones as $g) {
                        ?>
                        <option value="<?php echo $g['idgestion']; ?>"><?php echo $g['descripcion']; ?></option>
                        <?php
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtNombre">Nombre</label>
                <input type="text" id="txtNombre" name="txtNombre" class="form-control"
                    placeholder="Nombre y apellido del usuario" required />
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtUsuario">Usuario</label>
                <input type="text" id="txtUsuario" name="txtUsuario" class="form-control"
                    placeholder="Usuario, mínimo 4 caracteres" minlength="4" required />
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtClave">Clave</label>
                <input type="password" id="txtClave" name="txtClave" class="form-control"
                    placeholder="Clave mínimo 3 caracteres" minlength="3" required />
            </div>
            <div class="mb-3">
                <label class="form-label" for="txtCorreo">Correo</label>
                <input type="email" id="txtCorreo" name="txtCorreo" class="form-control"
                    placeholder="Correo electrónico" required />
            </div>
            <div class="mb-3">
                <label for="txtPrivilegios" class="form-label">Privilegios</label>
                <select class="form-select form-select-lg" name="txtPrivilegios" id="txtPrivilegios">
                    <?php
                    for ($i = 0; $i < count($lista_privilegios); $i++) {
                        echo '<option value="' . $i . '">' . $lista_privilegios[$i] . '</option>';
                    }
                    ?>
                </select>
            </div>
            <!-- Submit button -->
            <button type="submit" class="btn btn-success" id="btnEnviar">Agregar usuario</button>
            <a name="btnVolver" id="btnVolver" class="btn btn-primary" href="index.php" role="button">Volver</a>
        </form>
    </div>
    <div class="card-footer text-muted"></div>
</div>
<?php
include_once (TEMPLATE_PATH."footer.php");
?>