<?php
// Direccionamiento dinámico (Obligatorio)
include_once ($_SERVER['DOCUMENT_ROOT'] . '/sislotaip/dir.php');
include_once (TEMPLATE_PATH."header.php");
// Varibales de session
$aprobador = $_SESSION["aprobador"];
// Definicion de variables
$roles = array('0'=>'Operador', '1'=>'Responsable', '2'=>'Administrador', '3'=>'Superadministrador');
// Obtengo datos de usuario
$registros = $db->prepare("SELECT ROW_NUMBER() OVER (ORDER BY g.descripcion DESC) AS 'orden', g.idgestion, u.idusuario, 
    u.nombre, g.descripcion AS gestion, u.usuario, u.estado, u.privilegios, mc.aprobador, mc.estado AS estado_aprobador, mc.cargo 
    FROM usuarios u INNER JOIN gestiones g ON u.idgestion=g.idgestion LEFT JOIN miembros_comision mc ON u.idusuario=mc.idusuario");
$registros->execute();
?>
<!-- Mensaje de notificacion de transacción-->
<div class="mensaje alert alert-danger" style="display:none;" id="mensaje">Estado</div>
<div class="card">
    <div class="card-header">
        <a name="" id="" class="btn btn-success" href="crear.php" role="button">Agregar Usuario</a>
    </div>
    <div class="card-body">
        <div class="table-responsive-sm">
            <table class="table" id="tabla_id">
                <thead>
                    <tr>
                        <th scope="col" width="5%">Ord</th>
                        <th scope="col" width="10%">Nombre</th>
                        <th scope="col" width="10%">Gestion</th>
                        <th scope="col" width="10%">Usuario</th>
                        <th scope="col" width="10%">Rol</th>
                        <th scope="col" width="10%">Comisión</th>
                        <th scope="col" width="10%">Aprobador</th>
                        <th scope="col" width="10%">Estado</th>
                        <th scope="col" width="15%">Opciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $registros->fetch(PDO::FETCH_ASSOC)) {
                        ?>
                        <tr class="">
                            <td scope="row">
                                <?php echo $row["orden"]; ?>
                            </td>
                            <td>
                                <?php echo $row["nombre"]; ?>
                            </td>
                            <td>
                                <?php echo $row["gestion"]; ?>
                            </td>
                            <td>
                                <?php echo $row["usuario"]; ?>
                            </td>
                            <td>
                                <?php echo $roles[$row["privilegios"]]; ?>
                            </td>
                            <td>
                                <?php echo ($row["cargo"])? $row["cargo"]:'No'; ?>
                            </td>
                            <td>
                                <?php                                 
                                    echo ($row["aprobador"] == 1 && $row["estado_aprobador"] == 1)? 'Sí':'No';
                                ?>
                            </td>
                            <td>
                                <?php echo ($row["estado"] == 1) ? 'Activo' : 'Inactivo'; ?>
                            </td>
                            <td>
                                <!-- Botón editar -->
                                <a name="" id="" class="btn btn-primary"
                                    href="editar.php?idusuario=<?php echo $row["idusuario"]; ?>" role="button">Editar</a>
                                <!-- Botón eliminar -->
                                <input name="" id="" class="btn btn-danger" type="button" value="Eliminar"
                                    onclick='eliminar("<?php echo $row["idusuario"]; ?>", "<?php echo $row["nombre"]; ?>")'>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer text-muted">
        Descripción: Listado de usuarios del sistema.
    </div>
</div>

<!--Validaciones y funciones JavaScript-->
<script language="javascript">
    // Función para Eliminar registro
    const eliminar = async function (idusuario, nombre) {
        // Preparamos el formdata
        var opcion = confirm("¿Esta seguro que desea eliminar éste registro?");
        if (opcion == true) {
            const formData = new FormData();
            // Enviamos por POST
            formData.append("idusuario", idusuario);
            const respuestaRaw = await fetch("./eliminar.php", {
                method: "POST",
                body: formData,
            });
            const respuesta = await respuestaRaw.json();
            if (respuesta == 'Eliminado') {
                window.location.reload();
            } else {
                // Sacamos el resultado por consola
                setTimeout(function () {
                    $("#mensaje").html("No puede eliminar " + nombre + ", esta siendo utilizada en otro registro.");
                    $(".mensaje").fadeIn(1000);
                }, 0);
                setTimeout(function () {
                    $(".mensaje").fadeOut(1000);
                }, 5000);
            }
        }
    };
</script>
<?php
include_once (TEMPLATE_PATH."footer.php");
?>